% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/match.R
\name{match_find}
\alias{match_find}
\alias{match}
\title{Fuzzy matching of a text string}
\usage{
match_find(text, pattern, loc = 1L, threshold = NULL, distance = NULL)
}
\arguments{
\item{text}{The text to search.}

\item{pattern}{The pattern to search for.}

\item{loc}{The expected location of the pattern.}

\item{threshold}{Threshold for determining a match (0 - perfect match, 1 - very loose).}

\item{distance}{Distance from expected location scaling for score penalty.}
}
\value{
Index of best match or -1 for no match.
}
\description{
Locate the best instance of \code{pattern} in the \code{text} near \code{loc} using the
Bitap algorithm.Returns \code{-1} if no match found. Assumes R's typical 1-based indexing for \code{loc}
and the returned value.

This algorithm makes use of the \code{match_distance} and \code{match_threshold} options to determine
the match. If these values are not set explicitly via the \code{threshold} and \code{distance} arguments -
their value will use the currently set global option value.

Candidate matches are scored based on:
a) the number of spelling differences between the pattern and the text and
b) the distance between the candidate match and the expected location.

The \code{match_distance} option determines the relative importance of these two metrics.
}
\examples{
x = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor 
incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud 
exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure 
dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. 
Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt 
mollit anim id est laborum."

match_find(x, "Loren Ibsen")
match_find(x, "Loren Ibsen", threshold = 0.1)

match_find(x, "minimum")
match_find(x, "minimum", threshold = 0.4)

}
