#' Recode binary vectors
#'
#' @param binary.vec A binary vector of length \code{m} (>= 1) whose \code{k}th entry is 1.
#'
#' @param k A positive integer.
#'
#' @return A binary vector of length m that contains a single contiguous string of 1's, 
#'   namely the string that contains the 1 in the kth position of binary.vec.
#'
#' @details This function is called internally by \code{\link{peeling}}.
#'
#'
#' @examples
#' test = c(1, 0, 0, 1, 1, 0, 0, 1, 0)
#' recodeBinary(test, 5)   
#' #Returns (0, 0, 0, 1, 1, 0, 0, 0, 0)
#'
#' @export

recodeBinary = function(binary.vec, k) 
	{
    m = length(binary.vec)
    output.vec = rep(0, m)
    temp.spot = k
    temp.value = binary.vec[temp.spot]
    while ((temp.value > 0) && (temp.spot < m)) {
        output.vec[temp.spot] = 1
        temp.spot = temp.spot + 1
        temp.value = binary.vec[temp.spot]
    }
    if ((temp.spot == m) && (temp.value > 0)) {
        output.vec[temp.spot] = 1
    }
    temp.spot = k
    temp.value = binary.vec[temp.spot]
    while ((temp.value > 0) && (temp.spot > 1)) {
        output.vec[temp.spot] = 1
        temp.spot = temp.spot - 1
        temp.value = binary.vec[temp.spot]
    }
    if ((temp.spot == 1) && (temp.value > 0)) {
        output.vec[temp.spot] = 1
    }
    return(output.vec)
	}
