% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntiles.wtd.R
\name{ntiles.wtd}
\alias{ntiles.wtd}
\title{Weighted tiles}
\usage{
ntiles.wtd(x, n, weights = NULL)
}
\arguments{
\item{x}{a numeric vector for which the quantiles are computed. Missing values are left
as missing.}

\item{n}{the number of desired sub groups to break vector x into.}

\item{weights}{an optional vector of weights of x to be used in the computation of the
tiles. Should be NULL or a numeric vector.}
}
\value{
A vector of integers corresponding to the quantiles of vector x.
}
\description{
Breaks input vector into n groups. Returns the (optional weighted) tile of an
individual observation in vector x.
}
\details{
Breaks vector x into n sub groups. The main difference with other tile functions (for
instance ntile from dplyr) is that those functions break up vector x in exact equal size
sub groups. Observations with the same value can end up in different tiles. In this function,
observations with the same value always end up in the same tile, therefore sub groups may have
different sizes. Especially when the weights argument is used. For a weighted tile function
with the same group size, see for instance weighted_ntile from the grattan package.

When using a short-length vector (compared to the number of tiles) or with high variance weights,
output may be different than anticipated.
}
\examples{
#Break up the income variable in the Mexican Income data set into 10 groups (tiles)
data(mex_inc_2008)

#unweighted tiles:
q <- ntiles.wtd(x=mex_inc_2008$income, n=10)

#weighted tiles:
qw <- ntiles.wtd(x=mex_inc_2008$income, n=10, weights=mex_inc_2008$factor)

}
