% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disbayes-package.R
\docType{data}
\name{ihdengland}
\alias{ihdengland}
\title{Ischemic heart disease in England}
\format{
A data frame with columns:

\code{sex}: \code{"male"} or \code{"female"}. 

\code{ageyr}. Year of age. 

\code{location}. Name of the location, which is either a city region or region in England. 

\code{num_mort}. Numerator behind the estimate of mortality 

\code{num_inc}. Numerator behind the estimate of incidence

\code{num_prev}. Numerator behind the estimate of prevalence

\code{denom_mort}. Denominator behind the estimate of mortality 

\code{denom_inc}.  Denominator behind the estimate of incidence

\code{denom_prev}. Denominator behind the estimate of prevalence
}
\source{
Global Burden of Disease, 2017
}
\usage{
ihdengland
}
\description{
Ischemic heart disease in England
}
\details{
The data were processed to

* change the geography to refer to England city regions and the remaining English regions,

* change counts by 5-year age groups to estimated 1-year counts,

* obtain estimated numerators and denominators from the published point estimates and uncertainty intervals.
A point estimate of the risk is equivalent to the numerator divided by the denominator. The denominator is
related to the extent of uncertainty around this estimate, and obtained using the Bayesian method
implemented in \code{\link{ci2num}}. 

The script given in \url{https://github.com/chjackson/disbayes/blob/master/data-raw/gbd_process.Rmd} shows
these steps.
}
\references{
Jackson C, Zapata-Diomedi B, Woodcock J. "Bayesian multistate modelling of incomplete chronic disease burden data" \url{https://arxiv.org/abs/2111.14100}.
}
\keyword{datasets}
