% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEstimation.R
\name{covarGEE}
\alias{covarGEE}
\title{GEE covariance of all events for discrete competing risks}
\usage{
covarGEE(modelEst)
}
\arguments{
\item{modelEst}{Discrete time competing risks GEE model prediction model ("class dCRGEE").}
}
\value{
Returns symmetric matrix of rows and columns dimension "number of competing risks" * "number of regression parameters" ("numeric matrix").
}
\description{
Estimates covariance of estimated parameters of all competing events generalized estimation equation models using sandwich approach.
}
\examples{

# Example with unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
SubUnempDur <- UnempDur [1:100, ]

# Estimate GEE models for all events
estGEE <- compRisksGEE(datShort = SubUnempDur, dataTransform = "dataLongCompRisks", 
corstr = "independence", formulaVariable =~ timeInt + age + ui + logwage * ui, 
eventColumns = c("censor1", "censor2", "censor3", "censor4"), timeColumn = "spell")

\dontrun{
# Estimate covariance matrix of estimated parameters and competing events
estCovar <- covarGEE(modelEst=estGEE)
estCovar

# Covariances of estimated parameters of one event equal the diagonal blocks
lengthParameters <- length(estGEE[[1]]$coefficients)
noCompEvents <- length(estGEE)
meanAbsError <- rep(NA, noCompEvents)
for( k in 1:noCompEvents ){
  
  relInd <- (1 + (k-1) * lengthParameters) : (k * lengthParameters)
  meanAbsError[k] <- mean(abs(estCovar[relInd, relInd] - estGEE[[k]]$geese$vbeta))
  
}
mean(meanAbsError) 
# -> Covariance estimates within each event are equal to diagonal blocks in 
# complete covariance matrix with very small differences due to numerical accuracy.
}

}
\references{
\insertRef{minjungDiscComp}{discSurv}
}
\seealso{
\code{\link{compRisksGEE}}, \code{\link{dataLongCompRisks}}, \code{\link{dataLongCompRisksTimeDep}}, 
\code{\link[geepack]{geeglm}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{survival}
