% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fft_metrics.R
\name{fft_metrics}
\alias{fft_metrics}
\title{Discrete Fourier Transform Metrics}
\usage{
fft_metrics(data, candmin, candmax, river.name = "",
  baseline.signal = NULL)
}
\arguments{
\item{data}{A matrix with dates in the first column and discharge values in the second column.
Dates should be of the format "YYYY-MM-DD"}

\item{candmin}{numeric vector of possible ordinal days in which the predicted signal is lowest. This range need not be narrow, but a string of consecutive days should not include more than only local minimum. Used for calculating the high- and low-flow windows}

\item{candmax}{numeric vector of possible ordinal days in which the predicted signal is highest. This range need not be narrow, but a string of consecutive days should not include more than only local maximum.}

\item{river.name}{A character vector listing the river name.}

\item{baseline.signal}{If \code{NULL}, this function calculates baseline.signal using fourierAnalysis over the entire input series. The baseline signal can also be explicitly calculated and passed in as parameter. Check function \code{prepareBaseline()}}
}
\value{
A list containing 2 data frames:
\tabular{ll}{
\code{high.level.metrics} \tab Data frame containing NAA and FPExt values for each year in the given series\cr
\code{naa.shape.components} \tab Data frame containing HSAM, LSAM, Transition time, HSAF, LSAF, timing of HSAM, timing of LSAM, IFI, IDI
}
}
\description{
This is a wrapper function to calculate all the DFFT metrics for the given input signal
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# fetch the DFFT metrics for this sample data
# "candmax" chosen because preliminary analysis (e.g. with fourierAnalysis 
#           output) shows the signal is highest sometime between
#           day 190 and day 330
# "candmin" can be estimated analogously.
x.fftmetrics = fft_metrics(x, river.name = "Sycamore", candmin = c(40:125), 
                           candmax = c(190:330), baseline.signal = x.bl)

}
