% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space.maker.R
\name{random.circle}
\alias{random.circle}
\title{Random circle}
\usage{
random.circle(n, distribution, inner = 0, outer = Inf, ...)
}
\arguments{
\item{n}{The number of pairs x,y of coordinates.}

\item{distribution}{The distribution from which the coordinates are sampled.}

\item{inner}{Optional, the radius for an empty inner circle.}

\item{outer}{Optional, the maximum radius for the circle.}

\item{...}{Any additional argument to be passed to \code{distribution}.}
}
\description{
Creates coordinates for a random circle
}
\examples{
## A simple uniform circle
plot(random.circle(1000, runif), pch = 20)

## A normal ring with inner and outer boundaries
plot(random.circle(1000, rnorm, inner = 0.5, outer = 5), pch = 20)

}
\seealso{
\code{\link{space.maker}}
}
\author{
Thomas Guillerme
}
