% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTG-loglikelihood.R
\name{lFTG}
\alias{lFTG}
\title{FTG Log-likelihood Function}
\usage{
lFTG(x, threshold, scale, shape)
}
\arguments{
\item{x}{Sample data.}

\item{threshold}{Minimum value of the tail.}

\item{scale}{Scale parameter.}

\item{shape}{Shape parameter.}
}
\value{
Gives the log-likelihood of the FTG. The length of the result is determined by the length of x.
}
\description{
This function computes the loglikelihood of the full-tail gamma with the input sample data. The expression used is:
\deqn{l(x; \alpha, \sigma, \rho) = -n\left(\log\Gamma(\alpha, \rho) + \log(\sigma) -\alpha \log(\rho) - \frac{\alpha - 1}{n}\sum_{i = 1}^{n}\log\left(1 + \frac{x_{i}}{\sigma}\right) + \frac{\rho}{n} \sum_{i = 1}^{n}\left(1 + \frac{x_{i}}{\sigma}\right)\right)}
}
\examples{
lFTG(1,1,1,1)
}
\references{
del Castillo, Joan & Daoudi, Jalila & Serra, Isabel. (2012). The full-tails gamma distribution applied to model extreme values. ASTIN Bulletin. <doi:10.1017/asb.2017.9>.
}
\keyword{FTG}
