% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_dist_fns.R
\name{make_q_fn}
\alias{make_q_fn}
\title{Creates a function that evaluates the quantile function of an approximation
to a distribution obtained by interpolating and extrapolating from a set of
quantiles of the distribution.}
\usage{
make_q_fn(
  ps,
  qs,
  interior_method = "spline_cdf",
  interior_args = list(),
  tail_dist = "norm",
  dup_tol = 1e-06,
  zero_tol = 1e-12
)
}
\arguments{
\item{ps}{vector of probability levels}

\item{qs}{vector of quantile values corresponding to ps}

\item{interior_method}{method for interpolating the distribution on the
interior of the provided \code{qs}. This package provides one method for this,
\code{"spline_cdf"}. The user may also provide a custom function; see the
details for more.}

\item{interior_args}{an optional named list of arguments that are passed
on to the \code{interior_method}}

\item{tail_dist}{name of parametric distribution for the tails}

\item{dup_tol}{numeric tolerance for identifying duplicated values indicating
a discrete component of the distribution. If there is a run of values where
each consecutive pair is closer together than the tolerance, all are
labeled as duplicates even if not all values in the run are within the
tolerance.}

\item{zero_tol}{numeric tolerance for identifying values in \code{qs} that are
(approximately) zero.}
}
\value{
a function with argument \code{p} that can be used to calculate quantiles
of the approximated distribution at the probability levels \code{p}.
}
\description{
Creates a function that evaluates the quantile function of an approximation
to a distribution obtained by interpolating and extrapolating from a set of
quantiles of the distribution.
}
\details{
The default \code{interior_method}, \code{"spline_cdf"}, represents the
distribution as a sum of a discrete component at any points where there
are duplicated \code{qs} for multiple different \code{ps} and a continuous component
that is estimated by using a monotonic cubic spline that interpolates the
provided \verb{(q, p)} pairs as an estimate of the CDF. The quantile function
is then obtained by inverting this estimate of the CDF.

Optionally, the user may provide another function that accepts arguments
\code{ps}, \code{qs}, \code{tail_dist}, and \code{fn_type} (which will be either \code{"d"}, \code{"p"},
or \code{"q"}), and optionally additional named arguments to be specified via
\code{interior_args}. This function should return a function with argument \code{p}
that evaluates the quantile function.
}
