% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto.R
\name{clauset.xmin}
\alias{clauset.xmin}
\title{Pareto scale determination à la Clauset}
\usage{
clauset.xmin(x, q = 0)
}
\arguments{
\item{x}{data vector}

\item{q}{Percentage of data to search over (starting from the largest values)}
}
\value{
Returns a named list containing a
\describe{
\item{coefficients}{Named vector of coefficients}
\item{KS}{Minimum Kolmogorov-Smirnov distance}
\item{n}{Number of observations in the Pareto tail}
\item{coeff.evo}{Evolution of the Pareto shape parameter over the iterations}
}
}
\description{
This method determines the optimal scale parameter of the Pareto distribution using the iterative method \insertCite{clauset2009power}{distributionsrd}that minimizes the Kolmogorov-Smirnov distance.
}
\examples{

## Determine cuttof from compostie lognormal-Pareto distribution using Clauset's method
dist <- c("lnorm", "pareto")
coeff <- c(coeff1.meanlog = -0.5, coeff1.sdlog = 0.5, coeff2.k = 1.5)
x <- rcomposite(1e3, dist = dist, coeff = coeff)
out <- clauset.xmin(x = x)
out$coefficients
coeffcomposite(dist = dist, coeff = coeff, startc = c(1, 1))$coeff2

## Speed up method by considering values above certain quantile only
dist <- c("lnorm", "pareto")
coeff <- c(coeff1.meanlog = -0.5, coeff1.sdlog = 0.5, coeff2.k = 1.5)
x <- rcomposite(1e3, dist = dist, coeff = coeff)
out <- clauset.xmin(x = x, q = 0.5)
out$coefficients
coeffcomposite(dist = dist, coeff = coeff, startc = c(1, 1))$coeff2
}
\references{
\insertAllCited{}
}
