% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{wDefficiency}
\alias{wDefficiency}
\title{Weighted D Efficiency}
\usage{
wDefficiency(des, ref, mods, modw, A = NULL, parNames = NULL)
}
\arguments{
\item{des}{a design.}

\item{ref}{a design, the reference.}

\item{mods}{a list of models.}

\item{modw}{a vector of weights.}

\item{A}{for \itemize{
\item D-efficiency: \code{NULL}
\item D_s-efficiency: a vector of names or indices, the subset of parameters of interest.
\item D_A-efficiency: either \itemize{
  \item directly: a matrix without row names.
  \item indirectly: a matrix with row names corresponding to the parameters.
  }
}}

\item{parNames}{a vector of names or indices, the subset of parameters to use.
Defaults to the parameters for which the Fisher information is available.}
}
\value{
\code{wDefficiency} returns a single numeric.
}
\description{
\code{wDefficiency} computes the weighted D-, D_s or D_A-efficiency measure for a design with respect to a reference design.
}
\details{
Indices supplied to argument \code{A} correspond to the subset of parameters defined by argument \code{parNames}.

Weighted D efficiency is defined as
\deqn{\left(\frac{\exp\int_{\mathcal{B}}\log\left|M(\xi,\bar{\boldsymbol{\theta}})\right|\mathrm{d}B}{\exp\int_{\mathcal{B}}\log\left|M(\xi^{*},\bar{\boldsymbol{\theta}})\right|\mathrm{d}B}\right)^{1/n}}{( exp(integral( log(det(M(\xi, \theta))) , dB)) / exp(integral( log(det(M(\xi*, \theta))) , dB)) )**(1/n)}
and weighted D_A efficiency as
\deqn{\left(\frac{\exp\int_{\mathcal{B}}\log\left|A^{T}M(\xi,\bar{\boldsymbol{\theta}})^{-1}A\right|^{-1}\mathrm{d}B}{\exp\int_{\mathcal{B}}\log\left|A^{T}M(\xi^{*},\bar{\boldsymbol{\theta}})^{-1}A\right|^{-1}\mathrm{d}B}\right)^{1/s}}{( exp(integral( -log(det(t(A) \%*\% solve(M(\xi, \theta)) \%*\% A)) , dB)) / exp(integral( -log(det(t(A) \%*\% solve(M(\xi*, \theta)) \%*\% A)) , dB)) )**(1/s)}
}
\seealso{
\code{\link{design}}, \code{\link{param}}, \code{\link{Defficiency}}
}
