% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_helpers.R
\name{extract_above_threshold_vs_baseline}
\alias{extract_above_threshold_vs_baseline}
\title{Compute average of outcomes above dose threshold minus average of outcomes.}
\usage{
extract_above_threshold_vs_baseline(z, r, threshold)
}
\arguments{
\item{z}{a vector of doses}

\item{r}{a vector of outcomes}

\item{threshold}{a dose threshold}
}
\value{
the average of the outcomes with dose z above threshold c minus the
average of the outcomes r.
}
\description{
Compute average of outcomes above dose threshold minus average of outcomes.
}
\examples{
# dose vector
dose <- c(0, 0.1, 0.4)
# outcome vector
outcome <- c(1, 1.1, 1.5)
theta <- extract_above_threshold_vs_baseline(z = dose, r = outcome, threshold = 0.3)
}
