% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descTab.R
\name{descTab}
\alias{descTab}
\title{Generic function to create a table of descriptive analysis of a dataset}
\usage{
descTab(
  data,
  group = NULL,
  quanti = TRUE,
  quali = TRUE,
  na.print = FALSE,
  pvalue = TRUE,
  digits.p = 3L,
  digits.qt = 1L,
  digits.ql = 1L,
  normality = "normal",
  parallel = FALSE,
  mc.cores = 0
)
}
\arguments{
\item{data}{A datasaset. Needs to be a data.frame/tibble object}

\item{group}{Optional. The name of the variable to make sub-groups comparisons.}

\item{quanti, quali, na.print, pvalue}{Logical. If false, won't display quantitative/qualitative/Missing values/pvalues variable results}

\item{digits.p}{Integer. Significant digits for p value}

\item{digits.qt}{Integer. Significant digits for mean/median, SD/IQR}

\item{digits.ql}{Integer. Significant digits for proportions}

\item{normality}{One of "assess", "normal", "manual", "non normal". See details}

\item{parallel}{Logical. Make analysis using parallel from \code{\link[parallel:mclapply]{parallel::mclapply()}}.}

\item{mc.cores}{If parallel is TRUE, how many Cores to used.}
}
\value{
A S4 objects \code{\link[=parseClass]{parseClass()}} containing the main table accessible by ["table"] subscript.
}
\description{
This function allows you to display all together all univariate analysis (median/mean; IQR/SD; proportions)
and bivariates analysis (Wilcoxon, Chi² or Fisher).
The univariate analysis can be sub-grouped by a variable of interest of n levels. Appropriate statistics test will be applied
}
\examples{
data(iris)
library(stringi)
iris$fact_1<-as.factor(as.character(sample(1:5, 150, replace = TRUE)))
n_na<-sample(1:150, 30)
iris[n_na, "fact_1"]<-NA
iris$fact_2<-as.factor(as.character(sample(1:2, 150, replace = TRUE)))
n_na<-sample(1:150, 10)
iris[n_na, "fact_2"]<-NA
iris$fact_3<-as.factor(as.character(stri_rand_strings(150, 1, '[A-B]')))
iris$num<-runif(150, min = 0, max = 100)
n_na<-sample(1:150, 5)
iris[n_na, "num"]<-NA
iris_test<-descTab(iris, group = "Species", na.print = TRUE)
}
