/*
Register C callables to R.
*/
#define R_NO_REMAP
#include <R.h>
#include <Rinternals.h>
#include <Rdefines.h>
#include <Rconfig.h>
#include <R_ext/Rdynload.h>
#include "d.h"
SEXP dparse_sexp(SEXP sexp_fileName, SEXP sexp_start_state, SEXP sexp_save_parse_tree, SEXP sexp_partial_parses, SEXP sexp_compare_stacks, SEXP sexp_commit_actions_interval, SEXP sexp_fixup, SEXP sexp_fixup_ebnf, SEXP sexp_nogreedy, SEXP sexp_noheight, SEXP sexp_use_filename, SEXP sexp_sizeof_parse_node, SEXP sexp_verbose, SEXP sexp_children_first, SEXP fn, SEXP skip_fn, SEXP env, D_ParserTables pt);

extern int d_use_r_headers;
void set_d_use_r_headers(int x){
  d_use_r_headers = x;
}
int get_d_use_r_headers(void){
 return d_use_r_headers;
}

extern int d_rdebug_grammar_level;
void set_d_rdebug_grammar_level(int x){
  d_rdebug_grammar_level = x;
}
int get_d_rdebug_grammar_level(void){
 return d_rdebug_grammar_level;
}

extern int d_use_file_name;
void set_d_use_file_name(int x){
  d_use_file_name = x;
}
int get_d_use_file_name(void){
 return d_use_file_name;
}

extern int d_verbose_level;
void set_d_verbose_level(int x){
  d_verbose_level = x;
}
int get_d_verbose_level(void){
 return d_verbose_level;
}

extern int d_debug_level;
void set_d_debug_level(int x){
  d_debug_level = x;
}
int get_d_debug_level(void){
 return d_debug_level;
}

extern char * d_file_name;
void set_d_file_name(char *x){
  d_file_name=x;
}

D_Parser *new_D_Parser(struct D_ParserTables *t, int sizeof_ParseNode_User);
void free_D_Parser(D_Parser *p);
D_ParseNode *dparse(D_Parser *p, char *buf, int buf_len);
void free_D_ParseNode(D_Parser *p, D_ParseNode *pn);
void free_D_ParseTreeBelow(D_Parser *p, D_ParseNode *pn);
int d_get_number_of_children(D_ParseNode *pn);
D_ParseNode *d_get_child(D_ParseNode *pn, int child);
D_ParseNode *d_find_in_tree(D_ParseNode *pn, int symbol);
char *d_ws_before(D_Parser *p, D_ParseNode *pn);
char *d_ws_after(D_Parser *p, D_ParseNode *pn);
void d_pass(D_Parser *p, D_ParseNode *pn, int pass_number);
int resolve_amb_greedy(D_Parser *dp, int n, D_ParseNode **v);
char *d_dup_pathname_str(const char *str);
void parse_whitespace(struct D_Parser *p, d_loc_t *loc, void **p_globals);
D_Scope *new_D_Scope(D_Scope *parent);
D_Scope *enter_D_Scope(D_Scope *current, D_Scope *scope);
D_Scope *commit_D_Scope(D_Scope *scope);
D_Scope *equiv_D_Scope(D_Scope *scope);
D_Scope *global_D_Scope(D_Scope *scope);
D_Scope *scope_D_Scope(D_Scope *current, D_Scope *scope);
void free_D_Scope(D_Scope *st, int force);
D_Sym *new_D_Sym(D_Scope *st, char *name, char *end, int sizeof_D_Sym);
D_Sym *find_D_Sym(D_Scope *st, char *name, char *end);
D_Sym *find_global_D_Sym(D_Scope *st, char *name, char *end);
D_Sym *update_D_Sym(D_Sym *sym, D_Scope **st, int sizeof_D_Sym);
D_Sym *update_additional_D_Sym(D_Scope *st, D_Sym *sym, int sizeof_D_Sym);
D_Sym *current_D_Sym(D_Scope *st, D_Sym *sym);
D_Sym *find_D_Sym_in_Scope(D_Scope *st, D_Scope *cur, char *name, char *end);
D_Sym *next_D_Sym_in_Scope(D_Scope **st, D_Sym **sym);
void print_scope(D_Scope *st);
Grammar *new_D_Grammar(char *pathname);
void free_D_Grammar(Grammar *g);
int build_grammar(Grammar *g);
int parse_grammar(Grammar *g, char *pathname, char *str);
void print_grammar(Grammar *g);
void print_rdebug_grammar(Grammar *g, char *pathname);
void print_states(Grammar *g);
void print_rule(Rule *r);
void print_term(Term *t);
Production *lookup_production(Grammar *g, char *name, uint len);
Rule *new_rule(Grammar *g, Production *p);
Elem *new_elem_nterm(Production *p, Rule *r);
void new_declaration(Grammar *g, Elem *e, uint kind);
Production *new_production(Grammar *g, char *name);
Elem *new_string(Grammar *g, char *s, char *e, Rule *r);
Elem *new_utf8_char(Grammar *g, char *s, char *e, Rule *r);
Elem *new_ident(char *s, char *e, Rule *r);
void new_token(Grammar *g, char *s, char *e);
Elem *new_code(Grammar *g, char *s, char *e, Rule *r);
void add_global_code(Grammar *g, char *start, char *end, int line);
Production *new_internal_production(Grammar *g, Production *p);
Elem *dup_elem(Elem *e, Rule *r);
void add_declaration(Grammar *g, char *start, char *end, uint kind, uint line);
void add_pass(Grammar *g, char *start, char *end, uint kind, uint line);
void add_pass_code(Grammar *g, Rule *r, char *pass_start, char *pass_end, char *code_start, char *code_end, uint line, uint pass_line);
D_Pass *find_pass(Grammar *g, char *start, char *end);
void conditional_EBNF(Grammar *g);
void star_EBNF(Grammar *g);
void plus_EBNF(Grammar *g);
void rep_EBNF(Grammar *g, int minimum, int maximum);
void initialize_productions(Grammar *g);
uint state_for_declaration(Grammar *g, uint iproduction);
void build_scanners(struct Grammar *g);
void build_LR_tables(Grammar *g);
void sort_VecAction(VecAction *v);
uint elem_symbol(Grammar *g, Elem *e);
State *goto_State(State *s, Elem *e);
void free_Action(Action *a);
void mkdparse(struct Grammar *g, char *grammar_pathname);
void mkdparse_from_string(struct Grammar *g, char *str);
D_ParseNode *ambiguity_count_fn(D_Parser *pp, int n, D_ParseNode **v);
BinaryTables *read_binary_tables(char *file_name, D_ReductionCode spec_code, D_ReductionCode final_code);
BinaryTables *read_binary_tables_from_file(FILE *fp, D_ReductionCode spec_code, D_ReductionCode final_code);
BinaryTables *read_binary_tables_from_string(unsigned char *buf, D_ReductionCode spec_code, D_ReductionCode final_code);
void free_BinaryTables(BinaryTables *binary_tables);
int scan_buffer(d_loc_t *loc, D_State *st, ShiftResult *result);
void vec_add_internal(void *v, void *elem);
int vec_eq(void *v, void *vv);
int set_find(void *v, void *t);
int set_add(void *v, void *t);
int set_union(void *v, void *vv);
void set_union_fn(void *v, void *vv, hash_fns_t *fns);
void set_to_vec(void *av);
int buf_read(const char *pathname, char **buf, int *len);
char *sbuf_read(const char *pathname);
char *dup_str(const char *str, const char *end);
uint strhashl(const char *s, int len);
void d_free(void *);
void int_list_diff(int *a, int *b, int *c);
void int_list_intersect(int *a, int *b, int *c);
int *int_list_dup(int *aa);
char *escape_string(char *s);
char *escape_string_single_quote(char *s);
int write_c_tables(Grammar *g);
int write_binary_tables(Grammar *g);
int write_binary_tables_to_file(Grammar *g, FILE *fp);
int write_binary_tables_to_string(Grammar *g, unsigned char **str, unsigned int *str_len);

SEXP cDparser(SEXP fileName, SEXP sexp_output_file, SEXP set_op_priority_from_rule , SEXP right_recursive_BNF , SEXP states_for_whitespace , SEXP states_for_all_nterms , SEXP tokenizer , SEXP longest_match , SEXP sexp_grammar_ident , SEXP scanner_blocks , SEXP write_line_directives , SEXP rdebug, SEXP verbose, SEXP sexp_write_extension, SEXP write_header, SEXP token_type, SEXP use_r_header);


void __freeP(void);

SEXP dparserPtr(void) {
  int pro=0;

  SEXP dparse___freeP = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&__freeP, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_dparse_sexp = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&dparse_sexp, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_d_file_name = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_d_file_name, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_get_d_debug_level = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&get_d_debug_level, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_get_d_verbose_level = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&get_d_verbose_level, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_get_d_use_file_name = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&get_d_use_file_name, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_get_d_rdebug_grammar_level = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&get_d_rdebug_grammar_level, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_get_d_use_r_headers = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&get_d_use_r_headers, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_d_debug_level = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_d_debug_level, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_d_verbose_level = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_d_verbose_level, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_d_use_file_name = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_d_use_file_name, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_d_rdebug_grammar_level = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_d_rdebug_grammar_level, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_d_use_r_headers = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_d_use_r_headers, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_write_binary_tables_to_string = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&write_binary_tables_to_string, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_write_binary_tables_to_file = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&write_binary_tables_to_file, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_write_binary_tables = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&write_binary_tables, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_write_c_tables = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&write_c_tables, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_escape_string_single_quote = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&escape_string_single_quote, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_escape_string = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&escape_string, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_int_list_dup = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&int_list_dup, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_int_list_intersect = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&int_list_intersect, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_int_list_diff = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&int_list_diff, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_d_free = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&d_free, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_strhashl = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&strhashl, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_dup_str = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&dup_str, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_sbuf_read = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&sbuf_read, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_buf_read = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&buf_read, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_to_vec = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_to_vec, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_union_fn = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_union_fn, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_union = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_union, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_add = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_add, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_set_find = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&set_find, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_vec_eq = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&vec_eq, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_vec_add_internal = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&vec_add_internal, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_scan_buffer = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&scan_buffer, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_free_BinaryTables = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&free_BinaryTables, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_read_binary_tables_from_string = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&read_binary_tables_from_string, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_read_binary_tables_from_file = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&read_binary_tables_from_file, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_read_binary_tables = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&read_binary_tables, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_ambiguity_count_fn = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&ambiguity_count_fn, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_mkdparse_from_string = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&mkdparse_from_string, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_mkdparse = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&mkdparse, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_free_Action = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&free_Action, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_goto_State = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&goto_State, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_elem_symbol = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&elem_symbol, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_sort_VecAction = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&sort_VecAction, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_build_LR_tables = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&build_LR_tables, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_build_scanners = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&build_scanners, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_state_for_declaration = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&state_for_declaration, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_initialize_productions = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&initialize_productions, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_rep_EBNF = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&rep_EBNF, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_plus_EBNF         = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&plus_EBNF        , R_NilValue, R_NilValue)); pro++;
  SEXP dparse_star_EBNF         = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&star_EBNF        , R_NilValue, R_NilValue)); pro++;
  SEXP dparse_conditional_EBNF  = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&conditional_EBNF , R_NilValue, R_NilValue)); pro++;
  SEXP dparse_find_pass = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&find_pass, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_add_pass_code = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&add_pass_code, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_add_pass = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&add_pass, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_add_declaration = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&add_declaration, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_dup_elem = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&dup_elem, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_internal_production = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_internal_production, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_add_global_code = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&add_global_code, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_code = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_code, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_token = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_token, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_ident = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_ident, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_utf8_char = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_utf8_char, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_string = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_string, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_production = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_production, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_declaration = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_declaration, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_elem_nterm = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_elem_nterm, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_rule = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_rule, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_lookup_production = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&lookup_production, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_print_term = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&print_term, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_print_rule = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&print_rule, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_print_states = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&print_states, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_print_rdebug_grammar = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&print_rdebug_grammar, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_print_grammar = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&print_grammar, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_parse_grammar = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&parse_grammar, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_build_grammar = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&build_grammar, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_free_D_Grammar = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&free_D_Grammar, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_D_Grammar = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_D_Grammar, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_print_scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&print_scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_next_D_Sym_in_Scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&next_D_Sym_in_Scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_find_D_Sym_in_Scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&find_D_Sym_in_Scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_current_D_Sym = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&current_D_Sym, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_update_additional_D_Sym = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&update_additional_D_Sym, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_update_D_Sym = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&update_D_Sym, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_find_global_D_Sym = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&find_global_D_Sym, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_find_D_Sym = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&find_D_Sym, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_D_Sym = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_D_Sym, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_free_D_Scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&free_D_Scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_scope_D_Scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&scope_D_Scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_global_D_Scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&global_D_Scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_equiv_D_Scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&equiv_D_Scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_commit_D_Scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&commit_D_Scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_enter_D_Scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&enter_D_Scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_D_Scope = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_D_Scope, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_parse_whitespace = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&parse_whitespace, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_d_dup_pathname_str = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&d_dup_pathname_str, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_resolve_amb_greedy = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&resolve_amb_greedy, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_d_pass = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&d_pass, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_d_ws_after   = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&d_ws_after  , R_NilValue, R_NilValue)); pro++;
  SEXP dparse_d_ws_before  = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&d_ws_before , R_NilValue, R_NilValue)); pro++;
  SEXP dparse_d_find_in_tree = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&d_find_in_tree, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_d_get_child = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&d_get_child, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_d_get_number_of_children = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&d_get_number_of_children, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_free_D_ParseTreeBelow = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&free_D_ParseTreeBelow, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_free_D_ParseNode = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&free_D_ParseNode, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_dparse = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&dparse, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_free_D_Parser = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&free_D_Parser, R_NilValue, R_NilValue)); pro++;
  SEXP dparse_new_D_Parser = PROTECT(R_MakeExternalPtrFn((DL_FUNC)&new_D_Parser, R_NilValue, R_NilValue)); pro++;

  SEXP ret = PROTECT(Rf_allocVector(VECSXP, 110)); pro++;
  SET_VECTOR_ELT(ret, 0, dparse___freeP);
  SET_VECTOR_ELT(ret, 1, dparse_dparse_sexp);
  SET_VECTOR_ELT(ret, 2, dparse_set_d_file_name);
  SET_VECTOR_ELT(ret, 3, dparse_get_d_debug_level);
  SET_VECTOR_ELT(ret, 4, dparse_get_d_verbose_level);
  SET_VECTOR_ELT(ret, 5, dparse_get_d_use_file_name);
  SET_VECTOR_ELT(ret, 6, dparse_get_d_rdebug_grammar_level);
  SET_VECTOR_ELT(ret, 7, dparse_get_d_use_r_headers);
  SET_VECTOR_ELT(ret, 8, dparse_set_d_debug_level);
  SET_VECTOR_ELT(ret, 9, dparse_set_d_verbose_level);
  SET_VECTOR_ELT(ret, 10, dparse_set_d_use_file_name);
  SET_VECTOR_ELT(ret, 11, dparse_set_d_rdebug_grammar_level);
  SET_VECTOR_ELT(ret, 12, dparse_set_d_use_r_headers);
  SET_VECTOR_ELT(ret, 13, dparse_write_binary_tables_to_string);
  SET_VECTOR_ELT(ret, 14, dparse_write_binary_tables_to_file);
  SET_VECTOR_ELT(ret, 15, dparse_write_binary_tables);
  SET_VECTOR_ELT(ret, 16, dparse_write_c_tables);
  SET_VECTOR_ELT(ret, 17, dparse_escape_string_single_quote);
  SET_VECTOR_ELT(ret, 18, dparse_escape_string);
  SET_VECTOR_ELT(ret, 19, dparse_int_list_dup);
  SET_VECTOR_ELT(ret, 20, dparse_int_list_intersect);
  SET_VECTOR_ELT(ret, 21, dparse_int_list_diff);
  SET_VECTOR_ELT(ret, 22, dparse_d_free);
  SET_VECTOR_ELT(ret, 23, dparse_strhashl);
  SET_VECTOR_ELT(ret, 24, dparse_dup_str);
  SET_VECTOR_ELT(ret, 25, dparse_sbuf_read);
  SET_VECTOR_ELT(ret, 26, dparse_buf_read);
  SET_VECTOR_ELT(ret, 27, dparse_set_to_vec);
  SET_VECTOR_ELT(ret, 28, dparse_set_union_fn);
  SET_VECTOR_ELT(ret, 29, dparse_set_union);
  SET_VECTOR_ELT(ret, 30, dparse_set_add);
  SET_VECTOR_ELT(ret, 31, dparse_set_find);
  SET_VECTOR_ELT(ret, 32, dparse_vec_eq);
  SET_VECTOR_ELT(ret, 33, dparse_vec_add_internal);
  SET_VECTOR_ELT(ret, 34, dparse_scan_buffer);
  SET_VECTOR_ELT(ret, 35, dparse_free_BinaryTables);
  SET_VECTOR_ELT(ret, 36, dparse_read_binary_tables_from_string);
  SET_VECTOR_ELT(ret, 37, dparse_read_binary_tables_from_file);
  SET_VECTOR_ELT(ret, 38, dparse_read_binary_tables);
  SET_VECTOR_ELT(ret, 39, dparse_ambiguity_count_fn);
  SET_VECTOR_ELT(ret, 40, dparse_mkdparse_from_string);
  SET_VECTOR_ELT(ret, 41, dparse_mkdparse);
  SET_VECTOR_ELT(ret, 42, dparse_free_Action);
  SET_VECTOR_ELT(ret, 43, dparse_goto_State);
  SET_VECTOR_ELT(ret, 44, dparse_elem_symbol);
  SET_VECTOR_ELT(ret, 45, dparse_sort_VecAction);
  SET_VECTOR_ELT(ret, 46, dparse_build_LR_tables);
  SET_VECTOR_ELT(ret, 47, dparse_build_scanners);
  SET_VECTOR_ELT(ret, 48, dparse_state_for_declaration);
  SET_VECTOR_ELT(ret, 49, dparse_initialize_productions);
  SET_VECTOR_ELT(ret, 50, dparse_rep_EBNF);
  SET_VECTOR_ELT(ret, 51, dparse_plus_EBNF);
  SET_VECTOR_ELT(ret, 52, dparse_star_EBNF);
  SET_VECTOR_ELT(ret, 53, dparse_conditional_EBNF);
  SET_VECTOR_ELT(ret, 54, dparse_find_pass);
  SET_VECTOR_ELT(ret, 55, dparse_add_pass_code);
  SET_VECTOR_ELT(ret, 56, dparse_add_pass);
  SET_VECTOR_ELT(ret, 57, dparse_add_declaration);
  SET_VECTOR_ELT(ret, 58, dparse_dup_elem);
  SET_VECTOR_ELT(ret, 59, dparse_new_internal_production);
  SET_VECTOR_ELT(ret, 60, dparse_add_global_code);
  SET_VECTOR_ELT(ret, 61, dparse_new_code);
  SET_VECTOR_ELT(ret, 62, dparse_new_token);
  SET_VECTOR_ELT(ret, 63, dparse_new_ident);
  SET_VECTOR_ELT(ret, 64, dparse_new_utf8_char);
  SET_VECTOR_ELT(ret, 65, dparse_new_string);
  SET_VECTOR_ELT(ret, 66, dparse_new_production);
  SET_VECTOR_ELT(ret, 67, dparse_new_declaration);
  SET_VECTOR_ELT(ret, 68, dparse_new_elem_nterm);
  SET_VECTOR_ELT(ret, 69, dparse_new_rule);
  SET_VECTOR_ELT(ret, 70, dparse_lookup_production);
  SET_VECTOR_ELT(ret, 71, dparse_print_term);
  SET_VECTOR_ELT(ret, 72, dparse_print_rule);
  SET_VECTOR_ELT(ret, 73, dparse_print_states);
  SET_VECTOR_ELT(ret, 74, dparse_print_rdebug_grammar);
  SET_VECTOR_ELT(ret, 75, dparse_print_grammar);
  SET_VECTOR_ELT(ret, 76, dparse_parse_grammar);
  SET_VECTOR_ELT(ret, 77, dparse_build_grammar);
  SET_VECTOR_ELT(ret, 78, dparse_free_D_Grammar);
  SET_VECTOR_ELT(ret, 79, dparse_new_D_Grammar);
  SET_VECTOR_ELT(ret, 80, dparse_print_scope);
  SET_VECTOR_ELT(ret, 81, dparse_next_D_Sym_in_Scope);
  SET_VECTOR_ELT(ret, 82, dparse_find_D_Sym_in_Scope);
  SET_VECTOR_ELT(ret, 83, dparse_current_D_Sym);
  SET_VECTOR_ELT(ret, 84, dparse_update_additional_D_Sym);
  SET_VECTOR_ELT(ret, 85, dparse_update_D_Sym);
  SET_VECTOR_ELT(ret, 86, dparse_find_global_D_Sym);
  SET_VECTOR_ELT(ret, 87, dparse_find_D_Sym);
  SET_VECTOR_ELT(ret, 88, dparse_new_D_Sym);
  SET_VECTOR_ELT(ret, 89, dparse_free_D_Scope);
  SET_VECTOR_ELT(ret, 90, dparse_scope_D_Scope);
  SET_VECTOR_ELT(ret, 91, dparse_global_D_Scope);
  SET_VECTOR_ELT(ret, 92, dparse_equiv_D_Scope);
  SET_VECTOR_ELT(ret, 93, dparse_commit_D_Scope);
  SET_VECTOR_ELT(ret, 94, dparse_enter_D_Scope);
  SET_VECTOR_ELT(ret, 95, dparse_new_D_Scope);
  SET_VECTOR_ELT(ret, 96, dparse_parse_whitespace);
  SET_VECTOR_ELT(ret, 97, dparse_d_dup_pathname_str);
  SET_VECTOR_ELT(ret, 98, dparse_resolve_amb_greedy);
  SET_VECTOR_ELT(ret, 99, dparse_d_pass);
  SET_VECTOR_ELT(ret, 100, dparse_d_ws_after);
  SET_VECTOR_ELT(ret, 101, dparse_d_ws_before);
  SET_VECTOR_ELT(ret, 102, dparse_d_find_in_tree);
  SET_VECTOR_ELT(ret, 103, dparse_d_get_child);
  SET_VECTOR_ELT(ret, 104, dparse_d_get_number_of_children);
  SET_VECTOR_ELT(ret, 105, dparse_free_D_ParseTreeBelow);
  SET_VECTOR_ELT(ret, 106, dparse_free_D_ParseNode);
  SET_VECTOR_ELT(ret, 107, dparse_dparse);
  SET_VECTOR_ELT(ret, 108, dparse_free_D_Parser);
  SET_VECTOR_ELT(ret, 109, dparse_new_D_Parser);

  SEXP retN = PROTECT(Rf_allocVector(STRSXP, 110)); pro++;
  SET_STRING_ELT(retN, 0, Rf_mkChar("dparse___freeP"));
  SET_STRING_ELT(retN, 1, Rf_mkChar("dparse_dparse_sexp"));
  SET_STRING_ELT(retN, 2, Rf_mkChar("dparse_set_d_file_name"));
  SET_STRING_ELT(retN, 3, Rf_mkChar("dparse_get_d_debug_level"));
  SET_STRING_ELT(retN, 4, Rf_mkChar("dparse_get_d_verbose_level"));
  SET_STRING_ELT(retN, 5, Rf_mkChar("dparse_get_d_use_file_name"));
  SET_STRING_ELT(retN, 6, Rf_mkChar("dparse_get_d_rdebug_grammar_level"));
  SET_STRING_ELT(retN, 7, Rf_mkChar("dparse_get_d_use_r_headers"));
  SET_STRING_ELT(retN, 8, Rf_mkChar("dparse_set_d_debug_level"));
  SET_STRING_ELT(retN, 9, Rf_mkChar("dparse_set_d_verbose_level"));
  SET_STRING_ELT(retN, 10, Rf_mkChar("dparse_set_d_use_file_name"));
  SET_STRING_ELT(retN, 11, Rf_mkChar("dparse_set_d_rdebug_grammar_level"));
  SET_STRING_ELT(retN, 12, Rf_mkChar("dparse_set_d_use_r_headers"));
  SET_STRING_ELT(retN, 13, Rf_mkChar("dparse_write_binary_tables_to_string"));
  SET_STRING_ELT(retN, 14, Rf_mkChar("dparse_write_binary_tables_to_file"));
  SET_STRING_ELT(retN, 15, Rf_mkChar("dparse_write_binary_tables"));
  SET_STRING_ELT(retN, 16, Rf_mkChar("dparse_write_c_tables"));
  SET_STRING_ELT(retN, 17, Rf_mkChar("dparse_escape_string_single_quote"));
  SET_STRING_ELT(retN, 18, Rf_mkChar("dparse_escape_string"));
  SET_STRING_ELT(retN, 19, Rf_mkChar("dparse_int_list_dup"));
  SET_STRING_ELT(retN, 20, Rf_mkChar("dparse_int_list_intersect"));
  SET_STRING_ELT(retN, 21, Rf_mkChar("dparse_int_list_diff"));
  SET_STRING_ELT(retN, 22, Rf_mkChar("dparse_d_free"));
  SET_STRING_ELT(retN, 23, Rf_mkChar("dparse_strhashl"));
  SET_STRING_ELT(retN, 24, Rf_mkChar("dparse_dup_str"));
  SET_STRING_ELT(retN, 25, Rf_mkChar("dparse_sbuf_read"));
  SET_STRING_ELT(retN, 26, Rf_mkChar("dparse_buf_read"));
  SET_STRING_ELT(retN, 27, Rf_mkChar("dparse_set_to_vec"));
  SET_STRING_ELT(retN, 28, Rf_mkChar("dparse_set_union_fn"));
  SET_STRING_ELT(retN, 29, Rf_mkChar("dparse_set_union"));
  SET_STRING_ELT(retN, 30, Rf_mkChar("dparse_set_add"));
  SET_STRING_ELT(retN, 31, Rf_mkChar("dparse_set_find"));
  SET_STRING_ELT(retN, 32, Rf_mkChar("dparse_vec_eq"));
  SET_STRING_ELT(retN, 33, Rf_mkChar("dparse_vec_add_internal"));
  SET_STRING_ELT(retN, 34, Rf_mkChar("dparse_scan_buffer"));
  SET_STRING_ELT(retN, 35, Rf_mkChar("dparse_free_BinaryTables"));
  SET_STRING_ELT(retN, 36, Rf_mkChar("dparse_read_binary_tables_from_string"));
  SET_STRING_ELT(retN, 37, Rf_mkChar("dparse_read_binary_tables_from_file"));
  SET_STRING_ELT(retN, 38, Rf_mkChar("dparse_read_binary_tables"));
  SET_STRING_ELT(retN, 39, Rf_mkChar("dparse_ambiguity_count_fn"));
  SET_STRING_ELT(retN, 40, Rf_mkChar("dparse_mkdparse_from_string"));
  SET_STRING_ELT(retN, 41, Rf_mkChar("dparse_mkdparse"));
  SET_STRING_ELT(retN, 42, Rf_mkChar("dparse_free_Action"));
  SET_STRING_ELT(retN, 43, Rf_mkChar("dparse_goto_State"));
  SET_STRING_ELT(retN, 44, Rf_mkChar("dparse_elem_symbol"));
  SET_STRING_ELT(retN, 45, Rf_mkChar("dparse_sort_VecAction"));
  SET_STRING_ELT(retN, 46, Rf_mkChar("dparse_build_LR_tables"));
  SET_STRING_ELT(retN, 47, Rf_mkChar("dparse_build_scanners"));
  SET_STRING_ELT(retN, 48, Rf_mkChar("dparse_state_for_declaration"));
  SET_STRING_ELT(retN, 49, Rf_mkChar("dparse_initialize_productions"));
  SET_STRING_ELT(retN, 50, Rf_mkChar("dparse_rep_EBNF"));
  SET_STRING_ELT(retN, 51, Rf_mkChar("dparse_plus_EBNF"));
  SET_STRING_ELT(retN, 52, Rf_mkChar("dparse_star_EBNF"));
  SET_STRING_ELT(retN, 53, Rf_mkChar("dparse_conditional_EBNF"));
  SET_STRING_ELT(retN, 54, Rf_mkChar("dparse_find_pass"));
  SET_STRING_ELT(retN, 55, Rf_mkChar("dparse_add_pass_code"));
  SET_STRING_ELT(retN, 56, Rf_mkChar("dparse_add_pass"));
  SET_STRING_ELT(retN, 57, Rf_mkChar("dparse_add_declaration"));
  SET_STRING_ELT(retN, 58, Rf_mkChar("dparse_dup_elem"));
  SET_STRING_ELT(retN, 59, Rf_mkChar("dparse_new_internal_production"));
  SET_STRING_ELT(retN, 60, Rf_mkChar("dparse_add_global_code"));
  SET_STRING_ELT(retN, 61, Rf_mkChar("dparse_new_code"));
  SET_STRING_ELT(retN, 62, Rf_mkChar("dparse_new_token"));
  SET_STRING_ELT(retN, 63, Rf_mkChar("dparse_new_ident"));
  SET_STRING_ELT(retN, 64, Rf_mkChar("dparse_new_utf8_char"));
  SET_STRING_ELT(retN, 65, Rf_mkChar("dparse_new_string"));
  SET_STRING_ELT(retN, 66, Rf_mkChar("dparse_new_production"));
  SET_STRING_ELT(retN, 67, Rf_mkChar("dparse_new_declaration"));
  SET_STRING_ELT(retN, 68, Rf_mkChar("dparse_new_elem_nterm"));
  SET_STRING_ELT(retN, 69, Rf_mkChar("dparse_new_rule"));
  SET_STRING_ELT(retN, 70, Rf_mkChar("dparse_lookup_production"));
  SET_STRING_ELT(retN, 71, Rf_mkChar("dparse_print_term"));
  SET_STRING_ELT(retN, 72, Rf_mkChar("dparse_print_rule"));
  SET_STRING_ELT(retN, 73, Rf_mkChar("dparse_print_states"));
  SET_STRING_ELT(retN, 74, Rf_mkChar("dparse_print_rdebug_grammar"));
  SET_STRING_ELT(retN, 75, Rf_mkChar("dparse_print_grammar"));
  SET_STRING_ELT(retN, 76, Rf_mkChar("dparse_parse_grammar"));
  SET_STRING_ELT(retN, 77, Rf_mkChar("dparse_build_grammar"));
  SET_STRING_ELT(retN, 78, Rf_mkChar("dparse_free_D_Grammar"));
  SET_STRING_ELT(retN, 79, Rf_mkChar("dparse_new_D_Grammar"));
  SET_STRING_ELT(retN, 80, Rf_mkChar("dparse_print_scope"));
  SET_STRING_ELT(retN, 81, Rf_mkChar("dparse_next_D_Sym_in_Scope"));
  SET_STRING_ELT(retN, 82, Rf_mkChar("dparse_find_D_Sym_in_Scope"));
  SET_STRING_ELT(retN, 83, Rf_mkChar("dparse_current_D_Sym"));
  SET_STRING_ELT(retN, 84, Rf_mkChar("dparse_update_additional_D_Sym"));
  SET_STRING_ELT(retN, 85, Rf_mkChar("dparse_update_D_Sym"));
  SET_STRING_ELT(retN, 86, Rf_mkChar("dparse_find_global_D_Sym"));
  SET_STRING_ELT(retN, 87, Rf_mkChar("dparse_find_D_Sym"));
  SET_STRING_ELT(retN, 88, Rf_mkChar("dparse_new_D_Sym"));
  SET_STRING_ELT(retN, 89, Rf_mkChar("dparse_free_D_Scope"));
  SET_STRING_ELT(retN, 90, Rf_mkChar("dparse_scope_D_Scope"));
  SET_STRING_ELT(retN, 91, Rf_mkChar("dparse_global_D_Scope"));
  SET_STRING_ELT(retN, 92, Rf_mkChar("dparse_equiv_D_Scope"));
  SET_STRING_ELT(retN, 93, Rf_mkChar("dparse_commit_D_Scope"));
  SET_STRING_ELT(retN, 94, Rf_mkChar("dparse_enter_D_Scope"));
  SET_STRING_ELT(retN, 95, Rf_mkChar("dparse_new_D_Scope"));
  SET_STRING_ELT(retN, 96, Rf_mkChar("dparse_parse_whitespace"));
  SET_STRING_ELT(retN, 97, Rf_mkChar("dparse_d_dup_pathname_str"));
  SET_STRING_ELT(retN, 98, Rf_mkChar("dparse_resolve_amb_greedy"));
  SET_STRING_ELT(retN, 99, Rf_mkChar("dparse_d_pass"));
  SET_STRING_ELT(retN, 100, Rf_mkChar("dparse_d_ws_after"));
  SET_STRING_ELT(retN, 101, Rf_mkChar("dparse_d_ws_before"));
  SET_STRING_ELT(retN, 102, Rf_mkChar("dparse_d_find_in_tree"));
  SET_STRING_ELT(retN, 103, Rf_mkChar("dparse_d_get_child"));
  SET_STRING_ELT(retN, 104, Rf_mkChar("dparse_d_get_number_of_children"));
  SET_STRING_ELT(retN, 105, Rf_mkChar("dparse_free_D_ParseTreeBelow"));
  SET_STRING_ELT(retN, 106, Rf_mkChar("dparse_free_D_ParseNode"));
  SET_STRING_ELT(retN, 107, Rf_mkChar("dparse_dparse"));
  SET_STRING_ELT(retN, 108, Rf_mkChar("dparse_free_D_Parser"));
  SET_STRING_ELT(retN, 109, Rf_mkChar("dparse_new_D_Parser"));

  Rf_setAttrib(ret, R_NamesSymbol, retN);

  UNPROTECT(pro);
  return ret;
}

void R_init_dparser(DllInfo *info){
  R_CallMethodDef callMethods[]  = {
    {"_dparserPtr", (DL_FUNC) &dparserPtr, 0},
    {"cDparser", (DL_FUNC) &cDparser, 17},
    {NULL, NULL, 0}
  };
  R_registerRoutines(info, NULL, callMethods, NULL, NULL);
  R_useDynamicSymbols(info, FALSE);
  R_RegisterCCallable("dparser","__freeP",(DL_FUNC) __freeP);
  R_RegisterCCallable("dparser","dparse_sexp",(DL_FUNC) dparse_sexp);
  R_RegisterCCallable("dparser","set_d_file_name",(DL_FUNC) set_d_file_name);
  R_RegisterCCallable("dparser","get_d_debug_level",(DL_FUNC) get_d_debug_level);
  R_RegisterCCallable("dparser","get_d_verbose_level",(DL_FUNC) get_d_verbose_level);
  R_RegisterCCallable("dparser","get_d_use_file_name",(DL_FUNC) get_d_use_file_name);
  R_RegisterCCallable("dparser","get_d_rdebug_grammar_level",(DL_FUNC) get_d_rdebug_grammar_level);
  R_RegisterCCallable("dparser","get_d_use_r_headers",(DL_FUNC) get_d_use_r_headers);
  R_RegisterCCallable("dparser","set_d_debug_level",(DL_FUNC) set_d_debug_level);
  R_RegisterCCallable("dparser","set_d_verbose_level",(DL_FUNC) set_d_verbose_level);
  R_RegisterCCallable("dparser","set_d_use_file_name",(DL_FUNC) set_d_use_file_name);
  R_RegisterCCallable("dparser","set_d_rdebug_grammar_level",(DL_FUNC) set_d_rdebug_grammar_level);
  R_RegisterCCallable("dparser","set_d_use_r_headers",(DL_FUNC) set_d_use_r_headers);
  R_RegisterCCallable("dparser","write_binary_tables_to_string",(DL_FUNC) write_binary_tables_to_string);
  R_RegisterCCallable("dparser","write_binary_tables_to_file",(DL_FUNC) write_binary_tables_to_file);
  R_RegisterCCallable("dparser","write_binary_tables",(DL_FUNC) write_binary_tables);
  R_RegisterCCallable("dparser","write_c_tables",(DL_FUNC) write_c_tables);
  R_RegisterCCallable("dparser","escape_string_single_quote",(DL_FUNC) escape_string_single_quote);
  R_RegisterCCallable("dparser","escape_string",(DL_FUNC) escape_string);
  R_RegisterCCallable("dparser","int_list_dup",(DL_FUNC) int_list_dup);
  R_RegisterCCallable("dparser","int_list_intersect",(DL_FUNC) int_list_intersect);
  R_RegisterCCallable("dparser","int_list_diff",(DL_FUNC) int_list_diff);
  R_RegisterCCallable("dparser","d_free",(DL_FUNC) d_free);
  R_RegisterCCallable("dparser","strhashl",(DL_FUNC) strhashl);
  R_RegisterCCallable("dparser","dup_str",(DL_FUNC) dup_str);
  R_RegisterCCallable("dparser","sbuf_read",(DL_FUNC) sbuf_read);
  R_RegisterCCallable("dparser","buf_read",(DL_FUNC) buf_read);
  R_RegisterCCallable("dparser","set_to_vec",(DL_FUNC) set_to_vec);
  R_RegisterCCallable("dparser","set_union_fn",(DL_FUNC) set_union_fn);
  R_RegisterCCallable("dparser","set_union",(DL_FUNC) set_union);
  R_RegisterCCallable("dparser","set_add",(DL_FUNC) set_add);
  R_RegisterCCallable("dparser","set_find",(DL_FUNC) set_find);
  R_RegisterCCallable("dparser","vec_eq",(DL_FUNC) vec_eq);
  R_RegisterCCallable("dparser","vec_add_internal",(DL_FUNC) vec_add_internal);
  R_RegisterCCallable("dparser","scan_buffer",(DL_FUNC) scan_buffer);
  R_RegisterCCallable("dparser","free_BinaryTables",(DL_FUNC) free_BinaryTables);
  R_RegisterCCallable("dparser","read_binary_tables_from_string",(DL_FUNC) read_binary_tables_from_string);
  R_RegisterCCallable("dparser","read_binary_tables_from_file",(DL_FUNC) read_binary_tables_from_file);
  R_RegisterCCallable("dparser","read_binary_tables",(DL_FUNC) read_binary_tables);
  R_RegisterCCallable("dparser","ambiguity_count_fn",(DL_FUNC) ambiguity_count_fn);
  R_RegisterCCallable("dparser","mkdparse_from_string",(DL_FUNC) mkdparse_from_string);
  R_RegisterCCallable("dparser","mkdparse",(DL_FUNC) mkdparse);
  R_RegisterCCallable("dparser","free_Action",(DL_FUNC) free_Action);
  R_RegisterCCallable("dparser","goto_State",(DL_FUNC) goto_State);
  R_RegisterCCallable("dparser","elem_symbol",(DL_FUNC) elem_symbol);
  R_RegisterCCallable("dparser","sort_VecAction",(DL_FUNC) sort_VecAction);
  R_RegisterCCallable("dparser","build_LR_tables",(DL_FUNC) build_LR_tables);
  R_RegisterCCallable("dparser","build_scanners",(DL_FUNC) build_scanners);
  R_RegisterCCallable("dparser","state_for_declaration",(DL_FUNC) state_for_declaration);
  R_RegisterCCallable("dparser","initialize_productions",(DL_FUNC) initialize_productions);
  R_RegisterCCallable("dparser","rep_EBNF",(DL_FUNC) rep_EBNF);
  R_RegisterCCallable("dparser","plus_EBNF        ",(DL_FUNC) plus_EBNF        );
  R_RegisterCCallable("dparser","star_EBNF        ",(DL_FUNC) star_EBNF        );
  R_RegisterCCallable("dparser","conditional_EBNF ",(DL_FUNC) conditional_EBNF );
  R_RegisterCCallable("dparser","find_pass",(DL_FUNC) find_pass);
  R_RegisterCCallable("dparser","add_pass_code",(DL_FUNC) add_pass_code);
  R_RegisterCCallable("dparser","add_pass",(DL_FUNC) add_pass);
  R_RegisterCCallable("dparser","add_declaration",(DL_FUNC) add_declaration);
  R_RegisterCCallable("dparser","dup_elem",(DL_FUNC) dup_elem);
  R_RegisterCCallable("dparser","new_internal_production",(DL_FUNC) new_internal_production);
  R_RegisterCCallable("dparser","add_global_code",(DL_FUNC) add_global_code);
  R_RegisterCCallable("dparser","new_code",(DL_FUNC) new_code);
  R_RegisterCCallable("dparser","new_token",(DL_FUNC) new_token);
  R_RegisterCCallable("dparser","new_ident",(DL_FUNC) new_ident);
  R_RegisterCCallable("dparser","new_utf8_char",(DL_FUNC) new_utf8_char);
  R_RegisterCCallable("dparser","new_string",(DL_FUNC) new_string);
  R_RegisterCCallable("dparser","new_production",(DL_FUNC) new_production);
  R_RegisterCCallable("dparser","new_declaration",(DL_FUNC) new_declaration);
  R_RegisterCCallable("dparser","new_elem_nterm",(DL_FUNC) new_elem_nterm);
  R_RegisterCCallable("dparser","new_rule",(DL_FUNC) new_rule);
  R_RegisterCCallable("dparser","lookup_production",(DL_FUNC) lookup_production);
  R_RegisterCCallable("dparser","print_term",(DL_FUNC) print_term);
  R_RegisterCCallable("dparser","print_rule",(DL_FUNC) print_rule);
  R_RegisterCCallable("dparser","print_states",(DL_FUNC) print_states);
  R_RegisterCCallable("dparser","print_rdebug_grammar",(DL_FUNC) print_rdebug_grammar);
  R_RegisterCCallable("dparser","print_grammar",(DL_FUNC) print_grammar);
  R_RegisterCCallable("dparser","parse_grammar",(DL_FUNC) parse_grammar);
  R_RegisterCCallable("dparser","build_grammar",(DL_FUNC) build_grammar);
  R_RegisterCCallable("dparser","free_D_Grammar",(DL_FUNC) free_D_Grammar);
  R_RegisterCCallable("dparser","new_D_Grammar",(DL_FUNC) new_D_Grammar);
  R_RegisterCCallable("dparser","print_scope",(DL_FUNC) print_scope);
  R_RegisterCCallable("dparser","next_D_Sym_in_Scope",(DL_FUNC) next_D_Sym_in_Scope);
  R_RegisterCCallable("dparser","find_D_Sym_in_Scope",(DL_FUNC) find_D_Sym_in_Scope);
  R_RegisterCCallable("dparser","current_D_Sym",(DL_FUNC) current_D_Sym);
  R_RegisterCCallable("dparser","update_additional_D_Sym",(DL_FUNC) update_additional_D_Sym);
  R_RegisterCCallable("dparser","update_D_Sym",(DL_FUNC) update_D_Sym);
  R_RegisterCCallable("dparser","find_global_D_Sym",(DL_FUNC) find_global_D_Sym);
  R_RegisterCCallable("dparser","find_D_Sym",(DL_FUNC) find_D_Sym);
  R_RegisterCCallable("dparser","new_D_Sym",(DL_FUNC) new_D_Sym);
  R_RegisterCCallable("dparser","free_D_Scope",(DL_FUNC) free_D_Scope);
  R_RegisterCCallable("dparser","scope_D_Scope",(DL_FUNC) scope_D_Scope);
  R_RegisterCCallable("dparser","global_D_Scope",(DL_FUNC) global_D_Scope);
  R_RegisterCCallable("dparser","equiv_D_Scope",(DL_FUNC) equiv_D_Scope);
  R_RegisterCCallable("dparser","commit_D_Scope",(DL_FUNC) commit_D_Scope);
  R_RegisterCCallable("dparser","enter_D_Scope",(DL_FUNC) enter_D_Scope);
  R_RegisterCCallable("dparser","new_D_Scope",(DL_FUNC) new_D_Scope);
  R_RegisterCCallable("dparser","parse_whitespace",(DL_FUNC) parse_whitespace);
  R_RegisterCCallable("dparser","d_dup_pathname_str",(DL_FUNC) d_dup_pathname_str);
  R_RegisterCCallable("dparser","resolve_amb_greedy",(DL_FUNC) resolve_amb_greedy);
  R_RegisterCCallable("dparser","d_pass",(DL_FUNC) d_pass);
  R_RegisterCCallable("dparser","d_ws_after  ",(DL_FUNC) d_ws_after  );
  R_RegisterCCallable("dparser","d_ws_before ",(DL_FUNC) d_ws_before );
  R_RegisterCCallable("dparser","d_find_in_tree",(DL_FUNC) d_find_in_tree);
  R_RegisterCCallable("dparser","d_get_child",(DL_FUNC) d_get_child);
  R_RegisterCCallable("dparser","d_get_number_of_children",(DL_FUNC) d_get_number_of_children);
  R_RegisterCCallable("dparser","free_D_ParseTreeBelow",(DL_FUNC) free_D_ParseTreeBelow);
  R_RegisterCCallable("dparser","free_D_ParseNode",(DL_FUNC) free_D_ParseNode);
  R_RegisterCCallable("dparser","dparse",(DL_FUNC) dparse);
  R_RegisterCCallable("dparser","free_D_Parser",(DL_FUNC) free_D_Parser);
  R_RegisterCCallable("dparser","new_D_Parser",(DL_FUNC) new_D_Parser);
}

void R_unload_dparser(void) {
  __freeP();
}
