% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scans.R
\name{scanP}
\alias{scanP}
\title{Scan over different penalty \code{P} values}
\usage{
scanP(x, y, P, var = TRUE, use.matrix = TRUE, plot = TRUE,
  verb = 1, ...)
}
\arguments{
\item{x}{x-values}

\item{y}{y-values}

\item{P}{vector of penalties P to scan}

\item{var}{add the median of the variances of residuals of all
segments to output (save time by \code{var=FALSE})}

\item{use.matrix}{use the stored scoring function matrix for more
efficient scans; set this to \code{FALSE} if you run into
memory problems}

\item{plot}{plot results}

\item{verb}{print progress messages}

\item{...}{parameters for \code{\link{dpseg}} (except \code{P})}
}
\value{
Returns a matrix with the penalties P in the first column,
    the number of segments in the second column and the median of
    variances in the third column.
}
\description{
Runs the \code{\link{dpseg}} recursion for different values of the
penalty parameter \code{P} and returns a matrix with the used
\code{P} values, the resulting number of segments and (optionally)
the median of segment variance of residuals.
}
\examples{
x <- oddata$Time
y <- log(oddata$A5)
par(mai=c(par("mai")[1:3], par("mai")[2])) # to show right axis
sp <- scanP(x=x, y=y, P=seq(-.01,.1,length.out=50), plot=TRUE)
}
