% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initRepo.R
\name{initRepo}
\alias{initRepo}
\title{Intialize a git repo for drat}
\usage{
initRepo(name = "drat", basepath = getOption("dratDirectory", "~/git"),
  location = getOption("dratBranch", "gh-pages"))
}
\arguments{
\item{name}{A character variable with the name the new repository,
the default is \dQuote{drat}.}

\item{basepath}{A character variable with path to the directory in
which the new repository is to be created. The default value is
\dQuote{~/git} and can be overriden via option \sQuote{dratDirectory}.}

\item{location}{A character variable with the GitHub Pages location:
either \dQuote{gh-pages} indicating a branch of that name, or
\dQuote{docs/} directory in the main branch. The default value can
be overridden via the \dQuote{dratBranch} option.}
}
\value{
The function is invoked for its side-effects and only
returns \code{NULL} invisibly.
}
\description{
This helper function creates a new repository, creates and checks
out the default GitHub Pages location (either the \sQuote{gh-pages}
branch or directory \sQuote{docs}) and fills it with the required
new paths.
}
\details{
Currently only \sQuote{src/contrib} for source repositories is
supported by this function. The \code{insertPackage()} function knows
to deal with binaries for different architectures.

The function also installs a top-level \code{index.html} file to ensure
external tests against the repository (as for example done by CRAN if you
list the repository as an \sQuote{Additional_repositories} in a package)
do not return a \sQuote{404} error.
}
\author{
Dirk Eddelbuettel
}
