% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{drawPage}
\alias{drawPage}
\title{Create a New Drawing Page}
\usage{
drawPage(width = .pkgenv$pageWidth, height = .pkgenv$pageHeight,
  units = .pkgenv$units, ...)
}
\arguments{
\item{width}{Numeric value for the page width.}

\item{height}{Numeric value for the page height.}

\item{units}{Character value for the \link[grid]{unit} to use when specifying measurements.}

\item{...}{Additional arguments to \link[grid]{viewport}.}
}
\value{
A \link[grid]{viewport} object.
}
\description{
Create a New Drawing Page
}
\examples{
library(draw)

# Set drawing settings
drawSettings(pageWidth = 5, pageHeight = 5, units = "inches")

# Create a new drawing page
drawPage()

}
\seealso{
\link{drawSettings}
}
