% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{drawText}
\alias{drawText}
\title{Draw Text on the Page}
\usage{
drawText(x, y, text = .pkgenv$text, just = .pkgenv$textJust,
  hjust = .pkgenv$textHjust, vjust = .pkgenv$textVjust,
  angle = .pkgenv$textAngle, overlap = .pkgenv$textOverlap,
  opacity = .pkgenv$textOpacity, color = .pkgenv$textColor,
  size = .pkgenv$textSize, face = .pkgenv$textFace,
  family = .pkgenv$textFamily, lineHeight = .pkgenv$textLineHeight,
  units = .pkgenv$units, ...)
}
\arguments{
\item{x}{Numeric value for the x-axis position of the center.}

\item{y}{Numeric value for the y-axis position of the center.}

\item{text}{Character value of the text to display at \emph{xy} position.}

\item{just}{Character value of the text justification. One of "left", "right", "centre", "center", "bottom", or "top".}

\item{hjust}{Numeric value of the horizontal justification.}

\item{vjust}{Numeric value of the vertical justification.}

\item{angle}{Numeric value of the angle to rotate text.}

\item{overlap}{Logical value indicating if overlapping text should be removed (TRUE) or not (FALSE).}

\item{opacity}{Numeric value of the transparency for text ranging from 0 (transparent) to 1 (non-transparent).}

\item{color}{Character value of the color for text.}

\item{size}{Numeric value of the text font size in pt.}

\item{face}{Character value of the text font face. One of "plain", "bold", "italic", "oblique", and "bold.italic" (see \emph{fontface} in \link[grid]{gpar}).}

\item{family}{Character value of text font family to use (see \emph{family} in \link[graphics]{par}). Common values are "serif", "sans" and "mono".}

\item{lineHeight}{Numeric value of text line height as a multiple of the size of the text.}

\item{units}{Character value for the \link[grid]{unit} to use when specifying measurements.}

\item{...}{Additional arguments passed to \link[grid]{grid.text}.}
}
\value{
A \link[grid]{grid.text} \link[grid]{grob} object.
}
\description{
Draws text on the page given positioning, dimensions and styling.
\cr\cr
\if{html}{\figure{drawtext.png}{options: width=250 alt="Figure: drawText Example"}}
\if{latex}{\figure{drawtext.png}{options: width=3in alt="Figure: drawText Example"}}
}
\examples{
library(draw)

# Set drawing settings
drawSettings(pageWidth = 5, pageHeight = 5, units = "inches")

# Create a new drawing page
drawPage()

# Draw text on top left corner
drawText(x = 1, y = 4, text = "Top Left")

# Draw bold text on top right corner
drawText(x = 4, y = 4, text = "Top Right", face = "bold")

# Draw serif text on bottom left corner
drawText(x = 1, y = 1, text = "Bottom Left", family = "serif")

# Draw larger text on bottom right corner
drawText(x = 4, y = 1, text = "Bottom Right", size = 14)

# Export the drawing page to a PDF
drawExport("drawText.pdf")

}
\seealso{
\link{drawSettings}
}
