% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JLTZ.R
\name{JLTZ}
\alias{JLTZ}
\title{Reproduce the results of the Jiang et al. (2022)}
\usage{
JLTZ(iMonte, dgptype, n, g, pi, iPert, iq = 0.05, iridge = 0.001, seed = 1)
}
\arguments{
\item{iMonte}{A scalar. Monte Carlo sizes.}

\item{dgptype}{A scalar. The value can be string 1, 2, or 3,
respectively corresponding to the three random data generation methods in the paper (See Jiang et al. (2022) for DGP details).}

\item{n}{Sample size.}

\item{g}{Number of strata. We set g=4 in Jiang et al. (2022).}

\item{pi}{Targeted assignment probability across strata.}

\item{iPert}{A scalar. iPert = 0 means size. Otherwise means power: iPert is the perturbation of false null.}

\item{iq}{A scalar. Size of hypothesis testing. The authors set iq = 0.05.}

\item{iridge}{A scalar. The penalization parameter in ridge regression.}

\item{seed}{A scalar. The random seed, the authors set seed = 1 in Jiang et al. (2022).}
}
\value{
A table summarizing the estimated results, mProd.
}
\description{
Helps the user reproduce the results of the data simulation section of Jiang et al. (2022).
}
\examples{
\donttest{
# size, iPert = 0
JLTZ(iMonte = 10, dgptype = 1, n = 200, g = 4,
    pi = c(0.5, 0.5, 0.5, 0.5), iPert = 0, iq = 0.05, iridge = 0.001, seed = 1)

# power, iPert = 1
JLTZ(iMonte = 10, dgptype = 1, n = 200, g = 4,
    pi = c(0.5, 0.5, 0.5, 0.5), iPert = 1, iq = 0.05, iridge = 0.001, seed = 1)
}
}
\references{
Jiang L, Linton O B, Tang H, Zhang Y. Improving estimation efficiency via regression-adjustment in covariate-adaptive randomizations with imperfect compliance [J]. 2022.
}
