% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearLogit.R
\name{LinearLogit}
\alias{LinearLogit}
\title{Linear Regression or Logit Regression}
\usage{
LinearLogit(Y, D, A, X, S, s, modelflag, iridge)
}
\arguments{
\item{Y}{The outcome vector. A nx1 vector.}

\item{D}{A nx1 vector.}

\item{A}{The treatment assignment. A nx1 vector.}

\item{X}{Extra covariate matrix, A nxK matrix without constant.}

\item{S}{The strata variable.}

\item{s}{A particular stratum.}

\item{modelflag}{Its value ranges from characters 1, 2, and 3, respectively declaring different estimation strategies.
1-L; 2-NL; 3-R.}

\item{iridge}{A scalar. The penalization parameter in ridge regression.}
}
\value{
theta_0s, theta_1s, beta_0s, beta_1s are estimated coefficients vectors.
   The dimension is Kx1 if modelflag = 1; (K+1)x1 if modelflag = 2 or 3.
}
\description{
LinearLogit generates estimated pseudo true values for parametric models.
   Different estimation strategies are adopted according to different values of modelflag.
   See Jiang et al. (2022) for more details about different strategies.
}
\examples{
#' set.seed(1)
DGP <- FuncDGP(dgptype = 3, rndflag = 1, n = 10000, g = 4, pi = c(0.5, 0.5, 0.5, 0.5))
X <- DGP$X
Y <- DGP$Y
A <- DGP$A
S <- DGP$S
D <- DGP$D
LinearLogit(Y = Y, D = D, A = A, X = X, S = S, s = 1, modelflag = 1, iridge = 0.001)
LinearLogit(Y = Y, D = D, A = A, X = X, S = S, s = 2, modelflag = 2, iridge = 0.001)
LinearLogit(Y = Y, D = D, A = A, X = X, S = S, s = 3, modelflag = 3, iridge = 0.001)
LinearLogit(Y = Y, D = D, A = A, X = X, S = S, s = 4, modelflag = 3, iridge = 0.001)

}
\references{
Jiang L, Linton O B, Tang H, Zhang Y. Improving estimation efficiency via regression-adjustment in covariate-adaptive randomizations with imperfect compliance [J]. 2022.
}
