% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasiblePostLassoMatTool.R
\name{feasiblePostLassoMatTool}
\alias{feasiblePostLassoMatTool}
\title{Feasible Post Lasso Mat Tool}
\usage{
feasiblePostLassoMatTool(
  x,
  y,
  MaxIter = 30,
  UpsTol = 1e-06,
  beta0 = c(),
  clusterVar = c(),
  Dist = "normal",
  link = "identity",
  glmTol = 1e-08,
  initScale = 0.5
)
}
\arguments{
\item{x}{A nxk Matrix.}

\item{y}{A nx1 vector.}

\item{MaxIter}{Maximum iteration. The default value is 30.}

\item{UpsTol}{Upper limit of tolerance. The default value is 1e-6.}

\item{beta0}{NULL.}

\item{clusterVar}{NULL.}

\item{Dist}{The default value is normal.}

\item{link}{Link can be identity or logit.
This determines the method used for regression with the selected write variable after lasso.
See Jiang et al. (2022) for more details.}

\item{glmTol}{Maximum tolerance in GLM. The default value is 1e-8.}

\item{initScale}{Initial scale, the default value is 0.5.}
}
\value{
A kx1 cector, the coefficients b.
}
\description{
Under the condition of high dimensional data,
   the function first selects covariables through lasso regression,
   then performs logit regression or linear regression according to the caller's requirements,
   and finally returns the adjusted Lasso regression coefficient vector.
   This function has been slightly adapted for this package.
}
\examples{
set.seed(1)
# Notice that when we set dgptype = 3, FuncDGP will generate a high dimensional data for us.
DGP <- FuncDGP(dgptype = 3, rndflag = 1, n = 10000, g = 4, pi = c(0.5, 0.5, 0.5, 0.5))
X <- DGP$X
Y <- DGP$Y
A <- DGP$A
S <- DGP$S
D <- DGP$D
feasiblePostLassoMatTool(x = X[S==1 & A==0,], y = Y[S==1 & A==0,])
feasiblePostLassoMatTool(x = X[S==1 & A==0,], y = D[S==1 & A==0,], link = "logit")


}
\references{
Belloni, A., Chernozhukov, V., Fernández-Val, I. and Hansen, C. (2017), Program Evaluation and Causal Inference With High-Dimensional Data. Econometrica, 85: 233-298. https://doi.org/10.3982/ECTA12723
}
