% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuisance_fn.R
\name{estimate_treat_prob}
\alias{estimate_treat_prob}
\title{Estimate probability of receiving each level of treatment}
\usage{
estimate_treat_prob(treat, covar, treat_form, return_models)
}
\arguments{
\item{treat}{A \code{numeric} vector containing treatment status. Only values of
0 or 1 are treated as actual treatment levels. Any other value is assumed to encode
a value for which the outcome is missing.}

\item{covar}{A \code{data.frame} containing the covariates to include in the working
proportional odds model.}

\item{treat_form}{The right-hand side of a regression formula for the working model of
treatment probability as a function of covariates}

\item{return_models}{If \code{TRUE} the fitted working proportional odds models
and treatment probability models are returned.}
}
\value{
A list where the first element is estimate of Pr(\code{treat} = 1 | \code{covar})
for \code{covar} equal to inputted values of \code{covar}
and second element is estimate of Pr(\code{treat} = 0 | \code{covar})
for \code{covar} equal to inputted values of \code{covar}
}
\description{
Estimate probability of receiving each level of treatment
}
