% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_bias_normal.R
\name{Epgo_bias_normal}
\alias{Epgo_bias_normal}
\alias{Epgo_normal_L2}
\alias{Epgo_normal_R2}
\title{Expected probability to go to phase III for bias adjustment programs with normally distributed outcomes}
\usage{
Epgo_normal_L2(kappa, n2, Adj, w, Delta1, Delta2, in1, in2, a, b, fixed)

Epgo_normal_R2(kappa, n2, Adj, w, Delta1, Delta2, in1, in2, a, b, fixed)
}
\arguments{
\item{kappa}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be even number}

\item{Adj}{adjustment parameter}

\item{w}{weight for mixture prior distribution}

\item{Delta1}{assumed true treatment effect for standardized difference in means}

\item{Delta2}{assumed true treatment effect for standardized difference in means}

\item{in1}{amount of information for \code{Delta1} in terms of sample size}

\item{in2}{amount of information for \code{Delta2} in terms of sample size}

\item{a}{lower boundary for the truncation}

\item{b}{upper boundary for the truncation}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{Delta1} is used as fixed effect}
}
\value{
The output of the functions \code{Epgo_normal_L2} and \code{Epgo_normal_R2} is the expected number of participants in phase III with conservative decision rule and sample size calculation.
}
\description{
In the case we do not only want do discount for overoptimistic results in phase II when calculating the sample size in phase III,
but also when deciding whether to go to phase III or not the functions \code{Epgo_normal_L2} and \code{Epgo_normal_R2} are necessary.
The function \code{Epgo_normal_L2} uses an additive adjustment parameter (i.e. adjust the lower bound of the one-sided confidence interval),
the function \code{Epgo_normal_R2} uses a multiplicative adjustment parameter (i.e. use estimate with a retention factor)
}
\examples{
res <- Epgo_normal_L2(kappa = 0.1, n2 = 50, Adj = 0, w = 0.3,
                               Delta1 = 0.375, Delta2 = 0.625, in1 = 300, in2 = 600, 
                               a = 0.25, b = 0.75, fixed = FALSE)
          res <- Epgo_normal_R2(kappa = 0.1, n2 = 50, Adj = 1, w = 0.3,
                               Delta1 = 0.375, Delta2 = 0.625, in1 = 300, in2 = 600, 
                               a = 0.25, b = 0.75, fixed = FALSE)
}
\keyword{internal}
