% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_count_dataframe.R
\name{make_count_dataframe}
\alias{make_count_dataframe}
\title{Count the main marker expression}
\usage{
make_count_dataframe(
  .data,
  unique_name_row_identifier = "filter_image",
  name_of_the_markers_column = "Name"
)
}
\arguments{
\item{.data}{The dataframe that is coming from the processing of the microscopy data}

\item{unique_name_row_identifier}{The name of the column of the .data where the unique name can be used to counts (it defaults to "filter_image")}

\item{name_of_the_markers_column}{The name of the column of the .data where the marker names are expressed (ie E-Caderin, DAPI), "Defaults as Name"}
}
\value{
A \code{dataframe}/\code{tibble}.
}
\description{
This function counts every single marker present in the "Name" column of the data.frame and return a dataframe of the counts per marker
}
\examples{
\donttest{
# First load example data
pkg_path <- system.file("extdata/to_merge/", package = "drugsens")
bind_data <- data_binding(
  path_to_the_projects_folder = pkg_path,
  files_extension_to_look_for = "csv"
)

# Process the data
counts_dataframe <- make_count_dataframe(bind_data)

# Convert to plotting format
plotting_ready_dataframe <- change_data_format_to_longer(counts_dataframe)
}

\donttest{
# Example with custom parameters
make_count_dataframe(
  bind_data,
  name_of_the_markers_column = "Name",
  unique_name_row_identifier = "filter_image"
)
}
}
