% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_samplers.R
\name{btf_reg}
\alias{btf_reg}
\title{MCMC Sampler for Bayesian Trend Filtering: Regression}
\usage{
btf_reg(
  y,
  X = NULL,
  evol_error = "DHS",
  D = 1,
  obsSV = "const",
  nsave = 1000,
  nburn = 1000,
  nskip = 4,
  mcmc_params = list("mu", "yhat", "beta", "evol_sigma_t2", "obs_sigma_t2", "dhs_phi",
    "dhs_mean", "h", "h_smooth"),
  use_backfitting = FALSE,
  computeDIC = TRUE,
  verbose = TRUE,
  D_asv = 1,
  evol_error_asv = "HS",
  nugget_asv = TRUE
)
}
\arguments{
\item{y}{the \code{T x 1} vector of time series observations}

\item{X}{the \code{T x p} matrix of time series predictors}

\item{evol_error}{the evolution error distribution; must be one of
'DHS' (dynamic horseshoe prior), 'HS' (horseshoe prior), 'BL' (Bayesian lasso), or 'NIG' (normal-inverse-gamma prior)}

\item{D}{degree of differencing (D = 1 or D = 2)}

\item{obsSV}{Options for modeling the error variance. It must be one of the following:
\itemize{
\item const: Constant error variance for all time points.
\item SV: Stochastic Volatility model.
\item ASV: Adaptive Stochastic Volatility model.
}}

\item{nsave}{number of MCMC iterations to record}

\item{nburn}{number of MCMC iterations to discard (burin-in)}

\item{nskip}{number of MCMC iterations to skip between saving iterations,
i.e., save every (nskip + 1)th draw}

\item{mcmc_params}{named list of parameters for which we store the MCMC output;
must be one or more of:
\itemize{
\item "mu" (conditional mean)
\item "yhat" (posterior predictive distribution)
\item "beta" (dynamic regression coefficients)
\item "evol_sigma_t2" (evolution error variance)
\item "obs_sigma_t2" (observation error variance)
\item "dhs_phi" (DHS AR(1) coefficient)
\item "dhs_mean" (DHS AR(1) unconditional mean)
\item "h" (log variances or log of \code{"obs_sigma_t2"}. Only used when \code{obsSV = "ASV"})
\item "h_smooth" (smooth estimate of log variances. Only used when \code{obsSV = "ASV"} and \code{nugget_asv = TRUE})
}}

\item{use_backfitting}{logical; if TRUE, use backfitting to sample the predictors j=1,...,p
(faster, but usually less MCMC efficient)}

\item{computeDIC}{logical; if TRUE, compute the deviance information criterion \code{DIC}
and the effective number of parameters \code{p_d}}

\item{verbose}{logical; should R report extra information on progress?}

\item{D_asv}{integer; degree of differencing (0, 1, or 2) for the ASV model. Only used when \code{obsSV = "ASV"}.}

\item{evol_error_asv}{character; evolution error distribution for the ASV model. Must be one of the five options used in \code{evol_error}. Only used when \code{obsSV = "ASV"}.}

\item{nugget_asv}{logical; if \code{TRUE}, fits the nugget variant of the ASV model. Only used when \code{obsSV = "ASV"}.}
}
\value{
A named list of the \code{nsave} MCMC samples for the parameters named in \code{mcmc_params}
}
\description{
Run the MCMC for Bayesian trend filtering regression with a penalty on
first (D=1) or second (D=2) differences of each dynamic regression coefficient.
The penalty is determined by the prior on the evolution errors, which include:
\itemize{
\item the dynamic horseshoe prior ('DHS');
\item the static horseshoe prior ('HS');
\item the Bayesian lasso ('BL');
\item the normal stochastic volatility model ('SV');
\item the normal-inverse-gamma prior ('NIG').
}
In each case, the evolution error is a scale mixture of Gaussians.
Sampling is accomplished with a (parameter-expanded) Gibbs sampler,
mostly relying on a dynamic linear model representation.
}
\note{
The data \code{y} may contain NAs, which will be treated with a simple imputation scheme
via an additional Gibbs sampling step. In general, rescaling \code{y} to have unit standard
deviation is recommended to avoid numerical issues.
}
