% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abco.R
\name{t_sampleEvolParams}
\alias{t_sampleEvolParams}
\title{Sample the thresholded dynamic shrinkage process parameters}
\usage{
t_sampleEvolParams(
  omega,
  evolParams,
  D = 1,
  sigma_e = 1,
  lower_b,
  upper_b,
  loc,
  prior_dhs_phi = c(20, 1),
  alphaPlusBeta = 1
)
}
\arguments{
\item{omega}{\code{T} vector of evolution errors}

\item{evolParams}{list of parameters to be updated (see Value below)}

\item{D}{the degree of differencing (one or two)}

\item{sigma_e}{the observation error standard deviation; for (optional) scaling purposes}

\item{lower_b}{the lower bound in the uniform prior of the threshold variable}

\item{upper_b}{the upper bound in the uniform prior of the threshold variable}

\item{loc}{list of the row and column indices to fill in a band-sparse matrix}

\item{prior_dhs_phi}{the parameters of the prior for the log-volatility AR(1) coefficient \code{dhs_phi};
either \code{NULL} for uniform on [-1,1] or a 2-dimensional vector of (shape1, shape2) for a Beta prior
on \code{[(dhs_phi + 1)/2]}}

\item{alphaPlusBeta}{For the symmetric prior kappa ~ Beta(alpha, beta) with alpha=beta,
specify the sum [alpha + beta]}
}
\value{
List of relevant components:
\itemize{
\item the \code{T} evolution error standard deviations \code{sigma_wt},
\item the \code{T} log-volatility \code{ht},
\item the \code{1} log-vol unconditional mean(s) \code{dhs_mean},
\item the \code{1} log-vol AR(1) coefficient(s) \code{dhs_phi},
\item the \code{1} log-vol correction coefficient(s) \code{dhs_phi2},
\item the \code{T} log-vol innovation standard deviations \code{sigma_eta_t} from the Polya-Gamma priors,
\item the \code{1} initial log-vol SD \code{sigma_eta_0},
\item the \code{1} threshold parameter r
}
}
\description{
Compute one draw for each of the parameters in the thresholded dynamic shrinkage process
for the special case in which the shrinkage parameter \code{kappa ~ Beta(alpha, beta)}
with \code{alpha = beta = 1/2}.
}
\note{
The priors induced by \code{prior_dhs_phi} all imply a stationary (log-) volatility process.
}
