# =================================================================================================
# setup
# =================================================================================================

## Original objects in env
ols <- ls()

# =================================================================================================
# dtwb with L1 and L2 norms
# =================================================================================================

test_that("Pairwise proxy distances give the same result as references", {
    skip_on_cran()
    local_edition(2)

    D2_L1 <- proxy::dist(data[31L:46L], data[71L:86L], method = "dtw_basic")
    D2_L2 <- proxy::dist(data[31L:16L], data[71L:16L], method = "dtw_basic", norm = "L2")

    expect_known_value(D2_L1, "rds/dtwb_l1.rds")
    expect_known_value(D2_L2, "rds/dtwb_l2.rds")
})

# =================================================================================================
# clean
# =================================================================================================
rm(list = setdiff(ls(), ols))
