% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_utils.R
\name{ddbs_crs}
\alias{ddbs_crs}
\title{Check CRS of a table}
\usage{
ddbs_crs(conn, name, crs_column = "crs_duckspatial")
}
\arguments{
\item{conn}{A connection object to a DuckDB database}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names.}

\item{crs_column}{a character string of length one specifying the column
storing the CRS (created automatically by \code{\link{ddbs_write_vector}})}
}
\value{
CRS object
}
\description{
Check CRS of a table
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## load packages
library(duckdb)
library(duckspatial)
library(sf)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

## read data
countries_sf <- st_read(system.file("spatial/countries.geojson", package = "duckspatial"))

## store in duckdb
ddbs_write_vector(conn, countries_sf, "countries")

## check CRS
ddbs_crs(conn, "countries")
\dontshow{\}) # examplesIf}
}
