% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_predicates.R
\name{ddbs_disjoint}
\alias{ddbs_disjoint}
\title{Spatial disjoint predicate}
\usage{
ddbs_disjoint(
  x,
  y,
  conn = NULL,
  id_x = NULL,
  id_y = NULL,
  sparse = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{x}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.
Data is returned from this object.}

\item{y}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.}

\item{conn}{A connection object to a DuckDB database. If \code{NULL}, the function
runs on a temporary DuckDB database.}

\item{id_x}{Character; optional name of the column in \code{x} whose values will
be used to name the list elements. If \code{NULL}, integer row numbers of \code{x} are used.}

\item{id_y}{Character; optional name of the column in \code{y} whose values will
replace the integer indices returned in each element of the list.}

\item{sparse}{A logical value. If \code{TRUE}, it returns a sparse index list. If \code{FALSE},
it returns a dense logical matrix.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
A list where each element contains indices (or IDs) of geometries in \code{y} that
are disjoint from the corresponding geometry in \code{x}. See \code{\link[=ddbs_predicate]{ddbs_predicate()}} for details.
}
\description{
Tests if geometries in \code{x} are disjoint from geometries in \code{y}. Returns \code{TRUE}
if geometries have no points in common.
}
\details{
This is a convenience wrapper around \code{\link[=ddbs_predicate]{ddbs_predicate()}} with
\code{predicate = "disjoint"}.
}
\examples{
\dontrun{
## load packages
library(dplyr)
library(duckspatial)
library(sf)

## read countries data, and rivers
countries_sf <- read_sf(system.file("spatial/countries.geojson", package = "duckspatial")) |>
  filter(CNTR_ID \%in\% c("PT", "ES", "FR", "IT"))
rivers_sf <- st_read(system.file("spatial/rivers.geojson", package = "duckspatial")) |>
  st_transform(st_crs(countries_sf))

ddbs_disjoint(countries_sf, rivers_sf, id_x = "NAME_ENGL")
}
}
\seealso{
\code{\link[=ddbs_predicate]{ddbs_predicate()}} for other spatial predicates.
}
