% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_extension.R
\name{ddbs_install}
\alias{ddbs_install}
\title{Checks and installs the Spatial extension}
\usage{
ddbs_install(conn, upgrade = FALSE, quiet = FALSE)
}
\arguments{
\item{conn}{A connection object to a DuckDB database}

\item{upgrade}{if TRUE, it upgrades the DuckDB extension to the latest version}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
TRUE (invisibly) for successful installation
}
\description{
Checks if a spatial extension is available, and installs it in a DuckDB database
}
\examples{
## load packages
library(duckspatial)
library(duckdb)

# connect to in memory database
conn <- duckdb::dbConnect(duckdb::duckdb())

# install the spatial extension
ddbs_install(conn)

# disconnect from db
duckdb::dbDisconnect(conn)
}
