% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_predicates.R
\name{ddbs_is_within_distance}
\alias{ddbs_is_within_distance}
\title{Within Distance predicate}
\usage{
ddbs_is_within_distance(
  x,
  y,
  distance = NULL,
  conn = NULL,
  id_x = NULL,
  id_y = NULL,
  sparse = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{x}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.
Data is returned from this object.}

\item{y}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.}

\item{distance}{a numeric value specifying the distance for ST_DWithin. Units correspond to
the coordinate system of the geometry (e.g. degrees or meters)}

\item{conn}{A connection object to a DuckDB database. If \code{NULL}, the function
runs on a temporary DuckDB database.}

\item{id_x}{Character; optional name of the column in \code{x} whose values will
be used to name the list elements. If \code{NULL}, integer row numbers of \code{x} are used.}

\item{id_y}{Character; optional name of the column in \code{y} whose values will
replace the integer indices returned in each element of the list.}

\item{sparse}{A logical value. If \code{TRUE}, it returns a sparse index list. If \code{FALSE},
it returns a dense logical matrix.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
A list where each element contains indices (or IDs) of geometries in \code{y} that
touch the corresponding geometry in \code{x}. See \code{\link[=ddbs_predicate]{ddbs_predicate()}} for details.
}
\description{
Tests if geometries in \code{x} are within a specified distance of \code{y}. Returns
\code{TRUE} if geometries are within the distance.
}
\details{
This is a convenience wrapper around \code{\link[=ddbs_predicate]{ddbs_predicate()}} with
\code{predicate = "dwithin"}.
}
\examples{
\dontrun{
## load packages
library(dplyr)
library(duckspatial)
library(sf)

## read countries data, and rivers
countries_sf <- read_sf(system.file("spatial/countries.geojson", package = "duckspatial"))
countries_filter_sf <- countries_sf |> filter(CNTR_ID \%in\% c("PT", "ES", "FR", "IT"))

## check countries within 1 degree of distance
ddbs_is_within_distance(countries_filter_sf, countries_sf, 1)
}
}
\seealso{
\code{\link[=ddbs_predicate]{ddbs_predicate()}} for other spatial predicates.
}
