% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_batch_create_csv.R
\name{op_batch_create_csv}
\alias{op_batch_create_csv}
\title{Process all Dyad Directories to Create CSV Files Using MultimodalR}
\usage{
op_batch_create_csv(
  input_base_path,
  output_base_path,
  include_filename = TRUE,
  include_labels = FALSE,
  frame_width = 1920,
  export_type = "dyad",
  model = "all",
  overwrite = FALSE
)
}
\arguments{
\item{input_base_path}{Character. The base path containing dyad directories with JSON files.}

\item{output_base_path}{Character. The base path where the CSV files will be saved.}

\item{include_filename}{Logical. Whether to include filenames in the CSV. Default is TRUE.}

\item{include_labels}{Logical. Whether to include labels in the CSV. Default is FALSE.}

\item{frame_width}{Numeric. The width of the video frame in pixels. Default is 1920.}

\item{export_type}{Character. The type of export file, such as 'dyad' or other formats. Default is 'dyad'.}

\item{model}{Character. The model object to use for processing, e.g., 'all' or a specific model. Default is 'all'.}

\item{overwrite}{Logical. Whether to overwrite existing files. Default is FALSE.}
}
\value{
None. The function is called for its side effects.
}
\description{
This function processes all dyad directories in the specified input base path,
applying the \code{op_create_csv} function from the package, and saves
the output in the corresponding directories in the output base path.
}
