% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{get_posterior_param}
\alias{get_posterior_param}
\title{Compute posterior probability distribution parameters (e.g. credible intervals)
for an object of class \code{Counts}}
\usage{
get_posterior_param(object, low = 0.025, up = 0.975, ...)
}
\arguments{
\item{object}{object of class \code{Counts}}

\item{low}{1 - right tail posterior probability}

\item{up}{left tail posterior probability}

\item{...}{additional parameters to be passed to \link{plot_posterior}}
}
\value{
an object of class \code{Counts}
}
\description{
This function computes posterior parameters and credible intervals 
at the given confidence level (default to 95\%).
}
\examples{
counts <- new_counts(counts = c(20,30), fractions = c(0.075, 0.10))

# default parameters ("dup" algorithm, sampling without replacement, default prior support)
posterior <- compute_posterior(counts)

get_posterior_param(posterior)

}
\references{
Comoglio F, Fracchia L and Rinaldi M (2013) 
Bayesian inference from count data using discrete uniform priors. 
\href{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0074388}{PLoS ONE 8(10): e74388}

Clough HE et al. (2005) 
Quantifying Uncertainty Associated with Microbial Count Data: A Bayesian Approach. 
\href{https://onlinelibrary.wiley.com/doi/abs/10.1111/j.1541-0420.2005.030903.x}{Biometrics 61: 610-616}
}
\author{
Federico Comoglio
}
