% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{getncarc}
\alias{getncarc}
\alias{getncarc.ringscc}
\alias{getncarc.rings}
\alias{getncarc.xyLayout}
\alias{getncarc.ddArray}
\alias{getncarc.ddArraycc}
\alias{getncarc.dd}
\title{Simple Function to Extract Carcass Counts}
\usage{
getncarc(x, ...)

\method{getncarc}{ringscc}(x, ...)

\method{getncarc}{rings}(x, ...)

\method{getncarc}{xyLayout}(x, ...)

\method{getncarc}{ddArray}(x, ...)

\method{getncarc}{ddArraycc}(x, ...)

\method{getncarc}{dd}(x, ...)
}
\arguments{
\item{x}{a data structure with \code{ncarc} buried in it somewhere}

\item{...}{ignored}
}
\value{
\itemize{
   \item{scalar number of carcasses used in the fitted model 
    (\code{dd} and \code{ddArray} objects}
   \item{vector of numbers of carcasses of each size used in the fitted models 
    (\code{ddArraycc} objects)}
   \item{vector of carcass counts at each turbine and total at the site 
    (\code{xyLayout} and \code{rings} objects}
   \item{list of vectors of carcass counts at each turbine for each carcass class}
 }
}
\description{
Carcass counts are easy to extract from any of the data structures, but it
 may be difficult to remember where to retrieve the data from for any particular
 structure. \code{getncarc} simplifies the task by having the same usage for
 all data types.
}
