% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay.R
\name{Idd}
\alias{Idd}
\title{Double integral of decay function.}
\usage{
Idd(x, p)
}
\arguments{
\item{x}{Input value(s), possibly a vector.}

\item{p}{Parameter.}
}
\value{
Iterated integral of the decay function between 0 and x,
               that is, the integral of Id(x, p).
}
\description{
Double integral of decay function.
}
\examples{
   Idd(2, 0)
   Idd(1.5,0.5)
   Idd(2.5, -1)
   Idd(2.5, -0.5)
   for(p in seq(1, -1, -0.5)) curve(Idd(x, p), 0, 3, add=(p != 1))

}
