% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay.R
\name{decay}
\alias{decay}
\title{Decay function delta}
\usage{
decay(x, p)
}
\arguments{
\item{x}{Input value(s), possibly a vector.}

\item{p}{Parameter.}
}
\value{
Decay function value(s).
}
\description{
Calculates \eqn{(1 - p*x)_+^{1/p}}, or its limit \eqn{exp(-x)}
  when \eqn{p} tends to 0.
}
\details{
Perhaps overkill, but uses \code{log1p()} function for better
             accuracy than the more obvious formula.
}
\examples{
   decay(2, 0) == exp(-2)
   decay(1.5, 0.5)
   decay(2.5, 0.5)
   decay(2.5, -0.5)
   for(p in seq(1, -1, -0.5)) curve(decay(x, p), 0, 3, add=(p != 1))

}
