% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chiplot.R
\name{chiplot.fcm}
\alias{chiplot.fcm}
\alias{chiplot}
\title{Chi Plot for Fitted eFCM Model}
\usage{
\method{chiplot}{fcm}(
  object,
  h = NULL,
  method = c("default", "hessian", "boot"),
  ci = 0.95,
  emp = TRUE,
  which = c(1, 2),
  ...
)

chiplot(object, ...)
}
\arguments{
\item{object}{An object of class \code{"fcm"} returned by \code{\link[=fcm]{fcm()}}.}

\item{h}{A positive numeric distance in kilometers. If \code{NULL} and \code{emp = TRUE}, inferred from \code{coord[which, ]}.}

\item{method}{Character. Method for computing confidence intervals. One of \code{"default"}, \code{"hessian"}, or \code{"boot"}.}

\item{ci}{Confidence level for interval estimation.}

\item{emp}{Logical. Whether to add empirical chi estimates.}

\item{which}{Integer vector of length 2. Locations to compute empirical chi.}

\item{...}{Further arguments passed to base plotting functions (e.g., \code{main}, \code{xlab}, \code{ylab}, etc.).}
}
\value{
A (invisible) list containing chi estimates and confidence bounds:
\describe{
\item{chi.u}{Estimated chi values.}
\item{chi.lower}{Lower confidence bounds (if applicable).}
\item{chi.upper}{Upper confidence bounds (if applicable).}
\item{chi.emp}{Empirical chi curve (if \code{emp = TRUE}).}
\item{h}{Distance used.}
}
}
\description{
Plots the eFCM conditional exceedance probability \eqn{\chi_h(u)}.
}
\references{
Castro-Camilo, D. and Huser, R. (2020).
Local likelihood estimation of complex tail dependence structures,
applied to US precipitation extremes.
\emph{Journal of the American Statistical Association}, 115(531), 1037–1054.
}
\seealso{
\code{\link[=chi]{chi()}}, \code{\link[=Echi]{Echi()}}
}
