% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core3D.R
\name{get.densities.3d}
\alias{get.densities.3d}
\title{Extract tldCube and autodifference approximation functions}
\usage{
get.densities.3d(
  turnAngle,
  liftAngle,
  stepLength,
  deltaLift,
  deltaTurn,
  deltaStep,
  gradientAngle = NULL,
  heightEllipsoid = NULL,
  heightTopo = NULL,
  maxBin = 25
)
}
\arguments{
\item{turnAngle}{turn angles of the track (t)}

\item{liftAngle}{lift angles of the track (l)}

\item{stepLength}{stepLength of the track (d)}

\item{deltaLift}{auto differences of the turn angles (diff(t))}

\item{deltaTurn}{auto differences of the lift angles (diff(l))}

\item{deltaStep}{auto differences of the step length (diff(d))}

\item{gradientAngle}{\code{NULL} or the gardient angles of the track}

\item{heightEllipsoid}{flight height over the ellipsoid (absolute) or \code{NULL} to exclude this distribution}

\item{heightTopo}{flight height over the topography (relative) or \code{NULL} to exclude this distribution}

\item{maxBin}{numeric scalar, maximum number of bins per dimension of the tld-cube (\link[eRTG3D]{turnLiftStepHist})}
}
\value{
A list containing the tldCube and the autodifferences functions (and additionally the flight height distribution functions)
}
\description{
Creates a list consisting of the three dimensional
probability distribution cube for turning angle, lift angle and step length (\link[eRTG3D]{turnLiftStepHist})
as well as the uni-dimensional distributions of the differences
of the turn angles, lift angles and step lengths with a lag of 1 to maintain
minimal level of autocorrelation in each of the terms.
Additionally also the distribution of the flight height over the ellipsoid (absolute)
and the distribution of flight height over the topography (relative) can be included.
}
\examples{
niclas <- track.properties.3d(niclas)[2:nrow(niclas), ]
P <- get.densities.3d(
  turnAngle = niclas$t, liftAngle = niclas$l, stepLength = niclas$d,
  deltaLift = diff(niclas$t), deltaTurn = diff(niclas$l), deltaStep = diff(niclas$d),
  gradientAngle = NULL, heightEllipsoid = NULL, heightTopo = NULL, maxBin = 25
)
}
