% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edl_search.R
\name{edl_extract_urls}
\alias{edl_extract_urls}
\title{Extract data URLs from edl_search}
\usage{
edl_extract_urls(items)
}
\arguments{
\item{items}{the content object from edl_search}
}
\value{
a character vector of URLs
}
\description{
\strong{NOTE} this function uses heuristic rules to extract data
from edl_search(). Users are strongly encouraged to rely on
STAC searches instead.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

items <- edl_search(short_name = "MUR-JPL-L4-GLOB-v4.1",
                   temporal = c("2020-01-01", "2021-12-31"),
                   parse_urls = FALSE)

urls <- edl_extract_urls(items)
\dontshow{\}) # examplesIf}
}
