% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{epm_query_by_pmid}
\alias{epm_query_by_pmid}
\title{Query PubMed by PMIDs.}
\usage{
epm_query_by_pmid(pmids, api_key = NULL, verbose = TRUE)
}
\arguments{
\item{pmids}{Vector (character or numeric), list of 
Pubmed record identifiers (PMIDs). Values will be coerced to
character.}

\item{api_key}{String (character vector of length 1), 
corresponding to the NCBI API key. Can be `NULL`.}

\item{verbose}{Logical, shall details about the 
progress of the operation be printed to console.}
}
\value{
an easyPubMed object.
}
\description{
Query PubMed using a list of PubMed record identifiers (PMIDs) as input. 
The list of identifiers is automatically split into a series of 
manageable-sized chunks (max n=50 PMIDs per chunk).
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  my_pmids <- c(34097668, 34097669, 34097670)
  epm_query_by_pmid(my_pmids)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
