% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_classes_and_methods.R
\name{get_epm_uilist}
\alias{get_epm_uilist}
\title{Get PubMed Record Identifiers from an easyPubMed Object.}
\usage{
get_epm_uilist(x)
}
\arguments{
\item{x}{An `easyPubMed` object.}
}
\value{
a character vector including a list of unique record identifiers 
from an `easyPubMed` object.
}
\description{
Request the list of unique PubMed Record Identifiers that are contained 
in an `easyPubMed` object. This function is a wrapper
function calling the `getEPMUilist()` method. This function returns contents 
from the `uilist` slot.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  x <- epm_query(query_string = 'Damiano Fantini[AU] AND "2018"[PDAT]')
  x <- epm_fetch(x)
  get_epm_uilist(x)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

 
}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
