% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nem_plot.R
\name{nem_plot,ter-method}
\alias{nem_plot,ter-method}
\title{Visualizing the results of the ternary analysis (single factor)}
\usage{
\S4method{nem_plot}{ter}(object, type, point_size = 1, legend_cex = 0.9, ...)
}
\arguments{
\item{object}{A \code{\link{ter-class}} object.}

\item{type}{Visualize the nematodes by their \code{feeding} habits or by their \code{cp} values.}

\item{point_size}{Size of the points. Default is 1.}

\item{legend_cex}{Size of the legend text. Default is 0.9}

\item{...}{Additional parameters passed to \code{Ternary::TernaryPlot()}.}
}
\value{
A \code{recordedplot} object from \code{Ternary::TernaryPlot}.
}
\description{
The \code{\link{nem_plot}} function is generalized to the \code{\link{ter-class}}
and is used to visualize the results of the ternary analysis. This function
visualizes the distribution of nematode communities using the relative abundance
of nematodes of \code{cp1}, \code{cp2}, and \code{cp3-5} or the relative biomass
of herbivorous nematodes, bacterivorous nematodes, and fungivorous nematodes
as the three axes of a ternary plot.
}
\details{
To facilitate code interpretation, it is recommended to use the pipe symbol
\code{\link{|>}} to connect functions:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_plot <- nem |> calc_ter(Treatments) |> nem_plot()
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem2(tab = nemtab, tax = nemtax, meta = nemmeta)
nem_plot <- nem |>
            calc_ter(Treatments) |>
            nem_plot(type = feeding)
nem_plot
nem <- read_nem2(tab = nemtab, tax = nemtax, meta = nemmeta)
nem_plot <- nem |>
            calc_ter(Treatments) |>
            nem_plot(type = cp)
nem_plot
}
\references{
\itemize{
\item \url{https://shiny.wur.nl/ninja/}
\item Goede, RGM de, T. Bongers, and C. H. Ettema. "Graphical presentation and
interpretation of nematode community structure: cp triangles." (1993): 743-750.
}
}
\seealso{
The \code{nem_plot()} is used to visualize the calculation results and is a
generalized function for multiple classes including \code{\link{beta-class}},
\code{\link{beta2-class}}, \code{\link{compare-class}}, \code{\link{compare2-class}},
\code{\link{ef-class}}, \code{\link{ef2-class}}, \code{\link{funguild-class}},
\code{\link{funguild2-class}}, \code{\link{mf-class}}, \code{\link{mf2-class}},
\code{\link{ter-class}}, \code{\link{ter2-class}}, etc.
}
