% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropDuplicateIDs.R
\name{dropDuplicateIDs}
\alias{dropDuplicateIDs}
\title{Drop duplicate IDs in a \code{GADSdat}.}
\usage{
dropDuplicateIDs(GADSdat, ID, varNames = setdiff(namesGADS(GADSdat), ID))
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{ID}{Name of the ID variable.}

\item{varNames}{Character vector of variable names: Sum of missing values
on these variables decide which rows are kept. Per default, all variables
except the ID variable are used.}
}
\value{
Returns the \code{GADSdat} with duplicate ID rows removed.
}
\description{
Drop rows with duplicate IDs in a \code{GADSdat} object based on numbers of missing values.
}
\details{
If duplicate IDs occur, it is often desirable to keep the row with the least missing information.
Therefore, \code{dropDuplicateIDs} drops rows based on number of missing values
on the specified variables (\code{varNames}).

If multiple rows have the same number of missing values, a warning is issued
and the first of the respective rows is kept.
}
\examples{
# create example data set
gads_ori <- import_DF(data.frame(id_var = c(1, 2, 5, 4, 4),
  var1 = c(1, 2, -99, 1, -99)))
gads_ori <- changeMissings(gads_ori, varName = "var1",
  value = -99, missings = "miss")

# drop duplicate IDs
dropDuplicateIDs(gads_ori, ID = "id_var")

}
