% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeValLabels.R
\name{removeValLabels}
\alias{removeValLabels}
\title{Remove value labels and missing tags.}
\usage{
removeValLabels(GADSdat, varName, value, valLabel = NULL)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Character string of a variable name.}

\item{value}{Numeric values.}

\item{valLabel}{[optional] Regular expressions in the value labels corresponding to \code{value}.}
}
\value{
Returns the \code{GADSdat} object with changed meta data.
}
\description{
Remove meta data for specific values (\code{value}) of a single variable (\code{varName}).
This includes value labels and missings tags.
}
\details{
If the argument \code{valLabel} is provided, the function checks for \code{value} and \code{valLabel} pairs in the
meta data that match both arguments.
}
\examples{
# Remove a label based on value
extractMeta(pisa, "schtype")
pisa2 <- removeValLabels(pisa, varName = "schtype", value = 1)
extractMeta(pisa2, "schtype")

# Remove multiple labels based on value
extractMeta(pisa, "schtype")
pisa3 <- removeValLabels(pisa, varName = "schtype", value = 1:3)
extractMeta(pisa3, "schtype")

# Remove multiple labels based on value - valLabel combination
extractMeta(pisa, "schtype")
pisa4 <- removeValLabels(pisa, varName = "schtype",
                        value = 1:3, valLabel = c("Gymnasium", "other", "several courses"))
extractMeta(pisa4, "schtype")

}
