% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{e_visual_map_range}
\alias{e_visual_map_range}
\title{Select Visual Map}
\usage{
e_visual_map_range(e, ..., btn = NULL)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{...}{Any options, see
\href{https://echarts.apache.org/en/api.html#action.visualMap}{official
documentation}}

\item{btn}{A \code{\link{e_button}} id.}
}
\description{
Selects data range of visual mapping.
}
\examples{
data("state")

as.data.frame(state.x77) |>
  e_charts(Population) |>
  e_scatter(Income, Frost) |>
  e_visual_map(Frost, scale = e_scale) |>
  e_legend(FALSE) |>
  e_visual_map_range(
    selected = list(60, 120)
  )
}
