% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet.R
\name{e_leaflet}
\alias{e_leaflet}
\alias{e_leaflet_tile}
\title{Leaflet}
\usage{
e_leaflet(e, roam = TRUE, ...)

e_leaflet_tile(
  e,
  template = "https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png",
  options = NULL,
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{roam}{Whether to allow the user to roam.}

\item{...}{Any other option to pass, check See Also section.}

\item{template}{\code{urlTemplate}, should not be changed.}

\item{options}{List of options, including \code{attribution} and \code{label}.}
}
\description{
Leaflet extension.
}
\examples{
population |>
  dplyr::filter(value > 8) |>
  e_charts(lon) |>
  e_leaflet() |>
  e_leaflet_tile(options = list(maxZoom = 3)) |>
  e_scatter(lat, size = value, coord_system = "leaflet")

}
