% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{dd_dem}
\alias{dd_dem}
\title{Discrete Choice Predictions (HMNL)}
\usage{
dd_dem(dd, est, prob = FALSE, cores = NULL)
}
\arguments{
\item{dd}{tibble with long-format choice data}

\item{est}{estimation object}

\item{prob}{logical, report probabilities instead of demand}

\item{cores}{cores}
}
\value{
Draws of expected choice
}
\description{
Discrete Choice Predictions (HMNL)
}
\examples{
\donttest{
data(icecream_discrete)
icecream_est <- icecream_discrete \%>\% filter(id<10) \%>\% dd_est_hmnl(R=4, cores=2)
#demand prediction
icecream_dempred <- icecream_discrete \%>\% filter(id<10) \%>\% 
  dd_dem(icecream_est, cores=2)
}
}
\seealso{
\code{\link[=dd_est_hmnl]{dd_est_hmnl()}} to generate demand predictions based on this model
}
