% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{eode_is_validval}
\alias{eode_is_validval}
\title{Test the Validity of a Phase Point}
\usage{
eode_is_validval(x, value)
}
\arguments{
\item{x}{object of class "\code{eode}" representing an ODE system.}

\item{value}{an object of class "\code{pp}" representing a phase point in the
ODE system under consideration.}
}
\value{
returns \code{TRUE} or \code{FALSE} depending on whether the values of
the system variables are within the boundary or not.
}
\description{
Test whether a phase point sits out of the boundary of an ODE system.
}
\examples{
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2)
eode_is_validval(x, value = pp(list(x = 1, y = 1)))
}
