% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_Hutcheson_t_test.R
\name{multiple_Hutcheson_t_test}
\alias{multiple_Hutcheson_t_test}
\title{Multiple Hutcheson t-tests comparisons between communities.}
\usage{
multiple_Hutcheson_t_test(x, shannon.base = exp(1))
}
\arguments{
\item{x}{Numeric dataframe or matrix of abundance of species per community
sample. Columns must correspond to the samples and rows to species.}

\item{shannon.base}{Numeric value indicating the logarithm base for computing
the Shannon indexes. Defaults to \emph{exp(1)}.}
}
\value{
A matrix whose entries are the p-values from the test result rounded to
five digits. Self-comparison elements (matrix diagonal) are flagged with \emph{NA}.
The names of the rows and columns are the names of the communities with
their Shannon diversity index.
}
\description{
This function computes the p-values of the Hutcheson t-test to
test the significance of the difference between more than two communities
Shannon diversity indexes, in a pairwise way.
}
\details{
This function performs Hutcheson's t-tests for comparing multiple
diversity indexes pairwise. This test is based on the Shannon diversity
index computed using a logarithm base specified by the user. The alternative
hypothesis is one-sided, chosen automatically according to the sign of
the difference between each pair of communities tested. The resulting
p-values of the test are returned in a matrix. To see full details of
the results of the test comparing two communities it is better
to use \code{Hutcheson_t_test()}.
}
\note{
Missing values will be replaced with zero.
}
\examples{
data("polychaeta_abundance")
multiple_Hutcheson_t_test(x = polychaeta_abundance,
                           shannon.base = 10)
}
\seealso{
See \code{\link{Hutcheson_t_test}} for Hutcheson's t-test details.
}
\author{
David Ramirez Delgado \email{linfocitoth1@gmail.com}.

Hugo Salinas \email{hugosal@comunidad.unam.mx}.
}
