% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_null.R, R/s3_methods.R
\name{effect_null.manyglm}
\alias{effect_null.manyglm}
\alias{effect_null}
\title{Specify null effects for multivariate abundance data}
\usage{
\method{effect_null}{manyglm}(object, term)

effect_null(object, term)
}
\arguments{
\item{object}{objects of class \code{manyglm}, typically the result of a call to \code{\link[mvabund]{manyglm}}.}

\item{term}{Name of predictor of interest in quotes.}
}
\value{
A coefficient matrix with the null effect.
}
\description{
\code{effect_null} returns a coefficient matrix to be parsed to \code{\link{powersim}} by default
to specify a null effect.
}
\details{
\code{effect_null} produces a coefficient matrix with a null effect that is specified by setting the parameter
estimates of a predictor of interest \code{term} to 0. This function is used by default in \code{\link{powersim}}.
Note that intercept values are parameterised as in \code{\link{effect_alt}}.
}
\section{Functions}{
\itemize{
\item \code{effect_null()}: Specify null effects for multivariate abundance data

}}
\examples{
library(mvabund)
data(spider)
spiddat = mvabund(spider$abund)
X = data.frame(spider$x)

# Find null effect size for continuous predictor
spid.glm = manyglm(spiddat~soil.dry, family="negative.binomial", data=X)
coeffs0 = effect_null(spid.glm, term="soil.dry")
}
\seealso{
\code{\link{effect_alt}}, \code{\link{powersim}}
}
